/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml.installation;

import java.net.URI;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.keycloak.Config;
import org.keycloak.dom.saml.v2.metadata.KeyTypes;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.ClientInstallationProvider;
import org.keycloak.protocol.saml.SamlClient;
import org.keycloak.protocol.saml.SamlProtocol;
import org.keycloak.saml.SPMetadataDescriptor;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;

public class SamlSPDescriptorClientInstallation
implements ClientInstallationProvider {
    public static String getSPDescriptorForClient(ClientModel client) {
        String nameIdFormat;
        String logoutUrl;
        SamlClient samlClient = new SamlClient(client);
        String assertionUrl = client.getAttribute("saml_assertion_consumer_url_post");
        if (assertionUrl == null) {
            assertionUrl = client.getManagementUrl();
        }
        if ((logoutUrl = client.getAttribute("saml_single_logout_service_url_post")) == null) {
            logoutUrl = client.getManagementUrl();
        }
        if ((nameIdFormat = samlClient.getNameIDFormat()) == null) {
            nameIdFormat = SamlProtocol.SAML_DEFAULT_NAMEID_FORMAT;
        }
        String spCertificate = SPMetadataDescriptor.xmlKeyInfo((String)"        ", null, (String)samlClient.getClientSigningCertificate(), (String)KeyTypes.SIGNING.value(), (boolean)true);
        String encCertificate = SPMetadataDescriptor.xmlKeyInfo((String)"        ", null, (String)samlClient.getClientEncryptingCertificate(), (String)KeyTypes.ENCRYPTION.value(), (boolean)true);
        return SPMetadataDescriptor.getSPDescriptor((String)JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.get(), (String)assertionUrl, (String)logoutUrl, (boolean)samlClient.requiresClientSignature(), (boolean)samlClient.requiresAssertionSignature(), (boolean)samlClient.requiresEncryption(), (String)client.getClientId(), (String)nameIdFormat, (String)spCertificate, (String)encCertificate);
    }

    public Response generateInstallation(KeycloakSession session, RealmModel realm, ClientModel client, URI serverBaseUri) {
        String descriptor = SamlSPDescriptorClientInstallation.getSPDescriptorForClient(client);
        return Response.ok((Object)descriptor, (MediaType)MediaType.TEXT_PLAIN_TYPE).build();
    }

    public String getProtocol() {
        return "saml";
    }

    public String getDisplayType() {
        return "SAML Metadata SPSSODescriptor";
    }

    public String getHelpText() {
        return "SAML SP Metadata EntityDescriptor or rather SPSSODescriptor. This is an XML file.";
    }

    public String getFilename() {
        return "saml-sp-metadata.xml";
    }

    public String getMediaType() {
        return "application/xml";
    }

    public boolean isDownloadOnly() {
        return false;
    }

    public void close() {
    }

    public ClientInstallationProvider create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getId() {
        return "saml-sp-descriptor";
    }
}

