/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.theme;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.theme.ThemeResourceProvider;
import org.keycloak.theme.ThemeResourceProviderFactory;

public class ClasspathThemeResourceProviderFactory
implements ThemeResourceProviderFactory,
ThemeResourceProvider {
    public static final String THEME_RESOURCES_TEMPLATES = "theme-resources/templates/";
    public static final String THEME_RESOURCES_RESOURCES = "theme-resources/resources/";
    private final String id;
    private final ClassLoader classLoader;

    public ClasspathThemeResourceProviderFactory(String id, ClassLoader classLoader) {
        this.id = id;
        this.classLoader = classLoader;
    }

    public ThemeResourceProvider create(KeycloakSession session) {
        return this;
    }

    public URL getTemplate(String name) throws IOException {
        return this.classLoader.getResource(THEME_RESOURCES_TEMPLATES + name);
    }

    public InputStream getResourceAsStream(String path) throws IOException {
        return this.classLoader.getResourceAsStream(THEME_RESOURCES_RESOURCES + path);
    }

    public String getId() {
        return this.id;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }
}

