/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.mongo.keycloak.entities;

import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.models.entities.RoleEntity;
import org.keycloak.models.mongo.api.MongoCollection;
import org.keycloak.models.mongo.api.MongoField;
import org.keycloak.models.mongo.api.MongoIdentifiableEntity;
import org.keycloak.models.mongo.api.MongoIndex;
import org.keycloak.models.mongo.api.MongoStore;
import org.keycloak.models.mongo.api.context.MongoStoreInvocationContext;
import org.keycloak.models.mongo.keycloak.entities.MongoApplicationEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoRealmEntity;
import org.keycloak.models.mongo.keycloak.entities.MongoUserEntity;

@MongoCollection(collectionName="roles")
@MongoIndex(fields={"nameIndex"}, unique=true)
public class MongoRoleEntity
extends RoleEntity
implements MongoIdentifiableEntity {
    private static final Logger logger = Logger.getLogger(MongoRoleEntity.class);

    @MongoField
    public String getNameIndex() {
        String realmId = this.getRealmId();
        String applicationId = this.getApplicationId();
        String name = this.getName();
        if (realmId != null) {
            return realmId + "//" + name;
        }
        return applicationId + "//" + name;
    }

    public void setNameIndex(String ignored) {
    }

    @Override
    public void afterRemove(MongoStoreInvocationContext invContext) {
        MongoApplicationEntity appEntity;
        MongoRealmEntity realmEntity;
        MongoStore mongoStore = invContext.getMongoStore();
        DBObject query = new QueryBuilder().and("roleIds").is((Object)this.getId()).get();
        List<MongoUserEntity> users = mongoStore.loadEntities(MongoUserEntity.class, query, invContext);
        for (MongoUserEntity user : users) {
            logger.info((Object)("Removing role " + this.getName() + " from user " + user.getLoginName()));
            mongoStore.pullItemFromList(user, "roleIds", this.getId(), invContext);
        }
        query = new QueryBuilder().and("scopeIds").is((Object)this.getId()).get();
        users = mongoStore.loadEntities(MongoUserEntity.class, query, invContext);
        for (MongoUserEntity user : users) {
            logger.info((Object)("Removing scope " + this.getName() + " from user " + user.getLoginName()));
            mongoStore.pullItemFromList(user, "scopeIds", this.getId(), invContext);
        }
        if (this.getRealmId() != null && (realmEntity = mongoStore.loadEntity(MongoRealmEntity.class, this.getRealmId(), invContext)) != null) {
            mongoStore.pullItemFromList(realmEntity, "defaultRoles", this.getId(), invContext);
        }
        if (this.getApplicationId() != null && (appEntity = mongoStore.loadEntity(MongoApplicationEntity.class, this.getApplicationId(), invContext)) != null) {
            mongoStore.pullItemFromList(appEntity, "defaultRoles", this.getId(), invContext);
        }
        query = new QueryBuilder().and("compositeRoleIds").is((Object)this.getId()).get();
        List<MongoRoleEntity> parentRoles = mongoStore.loadEntities(MongoRoleEntity.class, query, invContext);
        for (MongoRoleEntity role : parentRoles) {
            mongoStore.pullItemFromList(role, "compositeRoleIds", this.getId(), invContext);
        }
    }
}

