/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.audit.mongo;

import com.mongodb.DB;
import com.mongodb.MongoClient;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.audit.AuditProvider;
import org.keycloak.audit.AuditProviderFactory;
import org.keycloak.audit.EventType;
import org.keycloak.audit.mongo.MongoAuditProvider;
import org.keycloak.provider.ProviderSession;

public class MongoAuditProviderFactory
implements AuditProviderFactory {
    protected static final Logger logger = Logger.getLogger(MongoAuditProviderFactory.class);
    public static final String ID = "mongo";
    private MongoClient client;
    private DB db;
    private Set<EventType> includedEvents = new HashSet<EventType>();

    public AuditProvider create(ProviderSession providerSession) {
        return new MongoAuditProvider(this.db.getCollection("audit"), this.includedEvents);
    }

    /*
     * WARNING - void declaration
     */
    public void init(Config.Scope config) {
        String[] exclude;
        try {
            String host = config.get("host", ServerAddress.defaultHost());
            int port = config.getInt("port", Integer.valueOf(ServerAddress.defaultPort()));
            String dbName = config.get("db", "keycloak-audit");
            boolean clearOnStartup = config.getBoolean("clearOnStartup", Boolean.valueOf(false));
            String string = config.get("user");
            String password = config.get("password");
            if (string != null && password != null) {
                MongoCredential credential = MongoCredential.createMongoCRCredential((String)string, (String)dbName, (char[])password.toCharArray());
                this.client = new MongoClient(new ServerAddress(host, port), Collections.singletonList(credential));
            } else {
                this.client = new MongoClient(host, port);
            }
            this.client.setWriteConcern(WriteConcern.UNACKNOWLEDGED);
            this.db = this.client.getDB(dbName);
            if (clearOnStartup) {
                this.db.getCollection("audit").drop();
            }
            logger.infof("Initialized mongo audit. host: %s, port: %d, db: %s, clearOnStartup: %b", new Object[]{host, port, dbName, clearOnStartup});
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        String[] include = config.getArray("include-events");
        if (include != null) {
            for (String string : include) {
                this.includedEvents.add(EventType.valueOf((String)string.toUpperCase()));
            }
        } else {
            for (String string : EventType.values()) {
                this.includedEvents.add((EventType)string);
            }
        }
        if ((exclude = config.getArray("exclude-events")) != null) {
            void var6_17;
            String[] arr$ = exclude;
            int len$ = arr$.length;
            boolean bl = false;
            while (var6_17 < len$) {
                String e = arr$[var6_17];
                this.includedEvents.remove(EventType.valueOf((String)e.toUpperCase()));
                ++var6_17;
            }
        }
    }

    public void close() {
        this.client.close();
    }

    public String getId() {
        return ID;
    }
}

