/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.audit.jpa;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.jboss.logging.Logger;
import org.keycloak.audit.AuditProvider;
import org.keycloak.audit.Event;
import org.keycloak.audit.EventQuery;
import org.keycloak.audit.EventType;
import org.keycloak.audit.jpa.EventEntity;
import org.keycloak.audit.jpa.JpaEventQuery;

public class JpaAuditProvider
implements AuditProvider {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final TypeReference<Map<String, String>> mapType = new TypeReference<Map<String, String>>(){};
    private static final Logger logger = Logger.getLogger(JpaAuditProvider.class);
    private EntityManager em;
    private EntityTransaction tx;
    private Set<EventType> includedEvents;

    public JpaAuditProvider(EntityManager em, Set<EventType> includedEvents) {
        this.em = em;
        this.includedEvents = includedEvents;
    }

    public EventQuery createQuery() {
        return new JpaEventQuery(this.em);
    }

    public void clear() {
        this.beginTx();
        this.em.createQuery("delete from EventEntity").executeUpdate();
    }

    public void clear(String realmId) {
        this.beginTx();
        this.em.createQuery("delete from EventEntity where realmId = :realmId").setParameter("realmId", (Object)realmId).executeUpdate();
    }

    public void clear(String realmId, long olderThan) {
        this.beginTx();
        this.em.createQuery("delete from EventEntity where realmId = :realmId and time < :time").setParameter("realmId", (Object)realmId).setParameter("time", (Object)olderThan).executeUpdate();
    }

    public void onEvent(Event event) {
        if (this.includedEvents.contains(event.getEvent())) {
            this.beginTx();
            this.em.persist((Object)JpaAuditProvider.convert(event));
        }
    }

    public void close() {
        if (this.tx != null) {
            this.tx.commit();
        }
        this.em.close();
    }

    private void beginTx() {
        if (this.tx == null) {
            this.tx = this.em.getTransaction();
            this.tx.begin();
        }
    }

    static EventEntity convert(Event o) {
        EventEntity e = new EventEntity();
        e.setId(UUID.randomUUID().toString());
        e.setTime(o.getTime());
        e.setEvent(o.getEvent().toString());
        e.setRealmId(o.getRealmId());
        e.setClientId(o.getClientId());
        e.setUserId(o.getUserId());
        e.setSessionId(o.getSessionId());
        e.setIpAddress(o.getIpAddress());
        e.setError(o.getError());
        try {
            e.setDetailsJson(mapper.writeValueAsString((Object)o.getDetails()));
        }
        catch (IOException ex) {
            logger.error((Object)"Failed to write log details", (Throwable)ex);
        }
        return e;
    }

    static Event convert(EventEntity o) {
        Event e = new Event();
        e.setTime(o.getTime());
        e.setEvent(EventType.valueOf((String)o.getEvent()));
        e.setRealmId(o.getRealmId());
        e.setClientId(o.getClientId());
        e.setUserId(o.getUserId());
        e.setSessionId(o.getSessionId());
        e.setIpAddress(o.getIpAddress());
        e.setError(o.getError());
        try {
            Map details = (Map)mapper.readValue(o.getDetailsJson(), mapType);
            e.setDetails(details);
        }
        catch (IOException ex) {
            logger.error((Object)"Failed to read log details", (Throwable)ex);
        }
        return e;
    }
}

