/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.freemarker;

import freemarker.cache.TemplateLoader;
import freemarker.cache.URLTemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.keycloak.Config;
import org.keycloak.freemarker.FreeMarkerException;
import org.keycloak.freemarker.Theme;

public class FreeMarkerUtil {
    private Map<String, Template> cache;

    public FreeMarkerUtil() {
        if (Config.scope((String[])new String[]{"theme"}).getBoolean("cacheTemplates", Boolean.valueOf(false)).booleanValue()) {
            this.cache = Collections.synchronizedMap(new HashMap());
        }
    }

    public String processTemplate(Object data, String templateName, Theme theme) throws FreeMarkerException {
        try {
            Template template;
            if (this.cache != null) {
                String key = theme.getName() + "/" + templateName;
                template = this.cache.get(key);
                if (template == null) {
                    template = this.getTemplate(templateName, theme);
                    this.cache.put(key, template);
                }
            } else {
                template = this.getTemplate(templateName, theme);
            }
            StringWriter out = new StringWriter();
            template.process(data, (Writer)out);
            return ((Object)out).toString();
        }
        catch (Exception e) {
            throw new FreeMarkerException("Failed to process template " + templateName, e);
        }
    }

    private Template getTemplate(String templateName, Theme theme) throws IOException {
        Configuration cfg = new Configuration();
        cfg.setTemplateLoader((TemplateLoader)new ThemeTemplateLoader(theme));
        return cfg.getTemplate(templateName);
    }

    class ThemeTemplateLoader
    extends URLTemplateLoader {
        private Theme theme;

        public ThemeTemplateLoader(Theme theme) {
            this.theme = theme;
        }

        protected URL getURL(String name) {
            try {
                return this.theme.getTemplate(name);
            }
            catch (IOException e) {
                return null;
            }
        }
    }
}

