/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.PublicKey;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.keycloak.OAuthErrorException;
import org.keycloak.audit.Audit;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.crypto.RSAProvider;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClaimMask;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.RefreshToken;
import org.keycloak.services.managers.AccessCodeEntry;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.util.Time;

public class TokenManager {
    protected static final Logger logger = Logger.getLogger(TokenManager.class);
    protected Map<String, AccessCodeEntry> accessCodeMap = new ConcurrentHashMap<String, AccessCodeEntry>();

    public void clearAccessCodes() {
        this.accessCodeMap.clear();
    }

    public AccessCodeEntry getAccessCode(String key) {
        return this.accessCodeMap.get(key);
    }

    public AccessCodeEntry pullAccessCode(String key) {
        return this.accessCodeMap.remove(key);
    }

    public static void applyScope(RoleModel role, RoleModel scope, Set<RoleModel> visited, Set<RoleModel> requested) {
        if (visited.contains(scope)) {
            return;
        }
        visited.add(scope);
        if (role.hasRole(scope)) {
            requested.add(scope);
            return;
        }
        if (!scope.isComposite()) {
            return;
        }
        for (RoleModel contained : scope.getComposites()) {
            TokenManager.applyScope(role, contained, visited, requested);
        }
    }

    public AccessCodeEntry createAccessCode(String scopeParam, String state, String redirect, RealmModel realm, ClientModel client, UserModel user, UserSessionModel session) {
        AccessCodeEntry code = this.createAccessCodeEntry(scopeParam, state, redirect, realm, client, user, session);
        this.accessCodeMap.put(code.getId(), code);
        return code;
    }

    private AccessCodeEntry createAccessCodeEntry(String scopeParam, String state, String redirect, RealmModel realm, ClientModel client, UserModel user, UserSessionModel session) {
        AccessCodeEntry code = new AccessCodeEntry();
        if (session != null) {
            code.setSessionState(session.getId());
        }
        List<RoleModel> realmRolesRequested = code.getRealmRolesRequested();
        MultivaluedMap<String, RoleModel> resourceRolesRequested = code.getResourceRolesRequested();
        AccessToken token = this.createClientAccessToken(scopeParam, realm, client, user, session, realmRolesRequested, resourceRolesRequested);
        token.setSessionState(code.getSessionState());
        code.setToken(token);
        code.setRealm(realm);
        code.setExpiration(Time.currentTime() + realm.getAccessCodeLifespan());
        code.setClient(client);
        code.setUser(user);
        code.setState(state);
        code.setRedirectUri(redirect);
        String accessCode = null;
        try {
            accessCode = new JWSBuilder().content(code.getId().getBytes("UTF-8")).rsa256(realm.getPrivateKey());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        code.setCode(accessCode);
        return code;
    }

    public AccessToken refreshAccessToken(UriInfo uriInfo, RealmModel realm, ClientModel client, String encodedRefreshToken, Audit audit) throws OAuthErrorException {
        ApplicationModel clientApp;
        JWSInput jws = new JWSInput(encodedRefreshToken);
        RefreshToken refreshToken = null;
        try {
            if (!RSAProvider.verify((JWSInput)jws, (PublicKey)realm.getPublicKey())) {
                throw new RuntimeException("Invalid refresh token");
            }
            refreshToken = (RefreshToken)jws.readJsonContent(RefreshToken.class);
        }
        catch (IOException e) {
            throw new OAuthErrorException("invalid_grant", "Invalid refresh token", (Throwable)e);
        }
        if (refreshToken.isExpired()) {
            throw new OAuthErrorException("invalid_grant", "Refresh token expired");
        }
        if (refreshToken.getIssuedAt() < realm.getNotBefore()) {
            throw new OAuthErrorException("invalid_grant", "Stale refresh token");
        }
        audit.user(refreshToken.getSubject()).session(refreshToken.getSessionState()).detail("refresh_token_id", refreshToken.getId());
        UserModel user = realm.getUserById(refreshToken.getSubject());
        if (user == null) {
            throw new OAuthErrorException("invalid_grant", "Invalid refresh token", "Unknown user");
        }
        if (!user.isEnabled()) {
            throw new OAuthErrorException("invalid_grant", "User disabled", "User disabled");
        }
        UserSessionModel session = realm.getUserSession(refreshToken.getSessionState());
        int currentTime = Time.currentTime();
        if (!AuthenticationManager.isSessionValid(realm, session)) {
            AuthenticationManager.logout(realm, session, uriInfo);
            throw new OAuthErrorException("invalid_grant", "Session not active", "Session not active");
        }
        if (!client.getClientId().equals(refreshToken.getIssuedFor())) {
            throw new OAuthErrorException("invalid_grant", "Unmatching clients", "Unmatching clients");
        }
        if (refreshToken.getIssuedAt() < client.getNotBefore() || refreshToken.getIssuedAt() < user.getNotBefore()) {
            throw new OAuthErrorException("invalid_grant", "Stale refresh token");
        }
        ApplicationModel applicationModel = clientApp = client instanceof ApplicationModel ? (ApplicationModel)client : null;
        if (refreshToken.getRealmAccess() != null) {
            for (String string : refreshToken.getRealmAccess().getRoles()) {
                RoleModel role = realm.getRole(string);
                if (role == null) {
                    throw new OAuthErrorException("invalid_grant", "Invalid realm role " + string);
                }
                if (!realm.hasRole(user, role)) {
                    throw new OAuthErrorException("invalid_grant", "User no long has permission for realm role: " + string);
                }
                if (realm.hasScope(client, role)) continue;
                throw new OAuthErrorException("invalid_grant", "Client no longer has realm scope: " + string);
            }
        }
        if (refreshToken.getResourceAccess() != null) {
            for (Map.Entry entry : refreshToken.getResourceAccess().entrySet()) {
                ApplicationModel app = realm.getApplicationByName((String)entry.getKey());
                if (app == null) {
                    throw new OAuthErrorException("invalid_grant", "Application no longer exists", "Application no longer exists: " + app.getName());
                }
                for (String roleName : ((AccessToken.Access)entry.getValue()).getRoles()) {
                    RoleModel role = app.getRole(roleName);
                    if (role == null) {
                        throw new OAuthErrorException("invalid_grant", "Invalid refresh token", "Unknown application role: " + roleName);
                    }
                    if (!realm.hasRole(user, role)) {
                        throw new OAuthErrorException("invalid_grant", "User no long has permission for application role " + roleName);
                    }
                    if (clientApp == null || clientApp.equals(app) || realm.hasScope(client, role)) continue;
                    throw new OAuthErrorException("invalid_grant", "Client no longer has application scope" + roleName);
                }
            }
        }
        AccessToken accessToken = this.initToken(realm, client, user, session);
        accessToken.setRealmAccess(refreshToken.getRealmAccess());
        accessToken.setResourceAccess(refreshToken.getResourceAccess());
        if (currentTime + realm.getAccessTokenLifespan() > session.getLastSessionRefresh() + realm.getSsoSessionIdleTimeout()) {
            session.setLastSessionRefresh(currentTime);
        }
        return accessToken;
    }

    public AccessToken createClientAccessToken(String scopeParam, RealmModel realm, ClientModel client, UserModel user, UserSessionModel session) {
        return this.createClientAccessToken(scopeParam, realm, client, user, session, new LinkedList<RoleModel>(), (MultivaluedMap<String, RoleModel>)new MultivaluedMapImpl());
    }

    public AccessToken createClientAccessToken(String scopeParam, RealmModel realm, ClientModel client, UserModel user, UserSessionModel session, List<RoleModel> realmRolesRequested, MultivaluedMap<String, RoleModel> resourceRolesRequested) {
        Set clientAppRoles;
        Set roleMappings = realm.getRoleMappings(user);
        Set scopeMappings = realm.getScopeMappings(client);
        ApplicationModel clientApp = client instanceof ApplicationModel ? (ApplicationModel)client : null;
        Set set = clientAppRoles = clientApp == null ? null : clientApp.getRoles();
        if (clientAppRoles != null) {
            scopeMappings.addAll(clientAppRoles);
        }
        HashSet<RoleModel> requestedRoles = new HashSet<RoleModel>();
        for (RoleModel role : roleMappings) {
            if (clientApp != null && role.getContainer().equals(clientApp)) {
                requestedRoles.add(role);
            }
            for (RoleModel desiredRole : scopeMappings) {
                HashSet<RoleModel> visited = new HashSet<RoleModel>();
                TokenManager.applyScope(role, desiredRole, visited, requestedRoles);
            }
        }
        for (RoleModel role : requestedRoles) {
            if (role.getContainer() instanceof RealmModel) {
                realmRolesRequested.add(role);
                continue;
            }
            if (!(role.getContainer() instanceof ApplicationModel)) continue;
            ApplicationModel app = (ApplicationModel)role.getContainer();
            resourceRolesRequested.add((Object)app.getName(), (Object)role);
        }
        AccessToken token = this.initToken(realm, client, user, session);
        if (realmRolesRequested.size() > 0) {
            for (RoleModel role : realmRolesRequested) {
                this.addComposites(token, role);
            }
        }
        if (resourceRolesRequested.size() > 0) {
            for (List roles : resourceRolesRequested.values()) {
                for (RoleModel role : roles) {
                    this.addComposites(token, role);
                }
            }
        }
        return token;
    }

    public void initClaims(IDToken token, ClientModel model, UserModel user) {
        if (ClaimMask.hasUsername((long)model.getAllowedClaimsMask())) {
            token.setPreferredUsername(user.getLoginName());
        }
        if (ClaimMask.hasEmail((long)model.getAllowedClaimsMask())) {
            token.setEmail(user.getEmail());
            token.setEmailVerified(Boolean.valueOf(user.isEmailVerified()));
        }
        if (ClaimMask.hasName((long)model.getAllowedClaimsMask())) {
            token.setFamilyName(user.getLastName());
            token.setGivenName(user.getFirstName());
            StringBuilder fullName = new StringBuilder();
            if (user.getFirstName() != null) {
                fullName.append(user.getFirstName()).append(" ");
            }
            if (user.getLastName() != null) {
                fullName.append(user.getLastName());
            }
            token.setName(fullName.toString());
        }
    }

    protected IDToken initIDToken(RealmModel realm, ClientModel claimer, UserModel client, UserModel user) {
        IDToken token = new IDToken();
        token.id(KeycloakModelUtils.generateId());
        token.subject(user.getId());
        token.audience(realm.getName());
        token.issuedNow();
        token.issuedFor(client.getLoginName());
        token.issuer(realm.getName());
        if (realm.getAccessTokenLifespan() > 0) {
            token.expiration(Time.currentTime() + realm.getAccessTokenLifespan());
        }
        this.initClaims(token, claimer, user);
        return token;
    }

    protected AccessToken initToken(RealmModel realm, ClientModel client, UserModel user, UserSessionModel session) {
        Set allowedOrigins;
        AccessToken token = new AccessToken();
        token.id(KeycloakModelUtils.generateId());
        token.subject(user.getId());
        token.audience(realm.getName());
        token.issuedNow();
        token.issuedFor(client.getClientId());
        token.issuer(realm.getName());
        if (session != null) {
            token.setSessionState(session.getId());
        }
        if (realm.getAccessTokenLifespan() > 0) {
            token.expiration(Time.currentTime() + realm.getAccessTokenLifespan());
        }
        if ((allowedOrigins = client.getWebOrigins()) != null) {
            token.setAllowedOrigins(allowedOrigins);
        }
        this.initClaims((IDToken)token, client, user);
        return token;
    }

    protected void addComposites(AccessToken token, RoleModel role) {
        AccessToken.Access access = null;
        if (role.getContainer() instanceof RealmModel) {
            access = token.getRealmAccess();
            if (token.getRealmAccess() == null) {
                access = new AccessToken.Access();
                token.setRealmAccess(access);
            } else if (token.getRealmAccess().getRoles() != null && token.getRealmAccess().isUserInRole(role.getName())) {
                return;
            }
        } else {
            ApplicationModel app = (ApplicationModel)role.getContainer();
            access = token.getResourceAccess(app.getName());
            if (access == null) {
                access = token.addAccess(app.getName());
                if (app.isSurrogateAuthRequired()) {
                    access.verifyCaller(Boolean.valueOf(true));
                }
            } else if (access.isUserInRole(role.getName())) {
                return;
            }
        }
        access.addRole(role.getName());
        if (!role.isComposite()) {
            return;
        }
        for (RoleModel composite : role.getComposites()) {
            this.addComposites(token, composite);
        }
    }

    public String encodeToken(RealmModel realm, Object token) {
        String encodedToken = new JWSBuilder().jsonContent(token).rsa256(realm.getPrivateKey());
        return encodedToken;
    }

    public AccessTokenResponseBuilder responseBuilder(RealmModel realm, ClientModel client, Audit audit) {
        return new AccessTokenResponseBuilder(realm, client, audit);
    }

    public class AccessTokenResponseBuilder {
        RealmModel realm;
        ClientModel client;
        AccessToken accessToken;
        RefreshToken refreshToken;
        IDToken idToken;
        Audit audit;

        public AccessTokenResponseBuilder(RealmModel realm, ClientModel client, Audit audit) {
            this.realm = realm;
            this.client = client;
            this.audit = audit;
        }

        public AccessTokenResponseBuilder accessToken(AccessToken accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public AccessTokenResponseBuilder refreshToken(RefreshToken refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public AccessTokenResponseBuilder generateAccessToken(String scopeParam, ClientModel client, UserModel user, UserSessionModel session) {
            this.accessToken = TokenManager.this.createClientAccessToken(scopeParam, this.realm, client, user, session);
            return this;
        }

        public AccessTokenResponseBuilder generateRefreshToken() {
            if (this.accessToken == null) {
                throw new IllegalStateException("accessToken not set");
            }
            this.refreshToken = new RefreshToken(this.accessToken);
            this.refreshToken.id(KeycloakModelUtils.generateId());
            this.refreshToken.issuedNow();
            this.refreshToken.expiration(Time.currentTime() + this.realm.getSsoSessionIdleTimeout());
            return this;
        }

        public AccessTokenResponseBuilder generateIDToken() {
            if (this.accessToken == null) {
                throw new IllegalStateException("accessToken not set");
            }
            this.idToken = new IDToken();
            this.idToken.id(KeycloakModelUtils.generateId());
            this.idToken.subject(this.accessToken.getSubject());
            this.idToken.audience(this.realm.getName());
            this.idToken.issuedNow();
            this.idToken.issuedFor(this.accessToken.getIssuedFor());
            this.idToken.issuer(this.accessToken.getIssuer());
            if (this.realm.getAccessTokenLifespan() > 0) {
                this.idToken.expiration(Time.currentTime() + this.realm.getAccessTokenLifespan());
            }
            this.idToken.setPreferredUsername(this.accessToken.getPreferredUsername());
            this.idToken.setGivenName(this.accessToken.getGivenName());
            this.idToken.setMiddleName(this.accessToken.getMiddleName());
            this.idToken.setFamilyName(this.accessToken.getFamilyName());
            this.idToken.setName(this.accessToken.getName());
            this.idToken.setNickName(this.accessToken.getNickName());
            this.idToken.setGender(this.accessToken.getGender());
            this.idToken.setPicture(this.accessToken.getPicture());
            this.idToken.setProfile(this.accessToken.getProfile());
            this.idToken.setWebsite(this.accessToken.getWebsite());
            this.idToken.setBirthdate(this.accessToken.getBirthdate());
            this.idToken.setEmail(this.accessToken.getEmail());
            this.idToken.setEmailVerified(this.accessToken.getEmailVerified());
            this.idToken.setLocale(this.accessToken.getLocale());
            this.idToken.setFormattedAddress(this.accessToken.getFormattedAddress());
            this.idToken.setAddress(this.accessToken.getAddress());
            this.idToken.setStreetAddress(this.accessToken.getStreetAddress());
            this.idToken.setLocality(this.accessToken.getLocality());
            this.idToken.setRegion(this.accessToken.getRegion());
            this.idToken.setPostalCode(this.accessToken.getPostalCode());
            this.idToken.setCountry(this.accessToken.getCountry());
            this.idToken.setPhoneNumber(this.accessToken.getPhoneNumber());
            this.idToken.setPhoneNumberVerified(this.accessToken.getPhoneNumberVerified());
            this.idToken.setZoneinfo(this.accessToken.getZoneinfo());
            return this;
        }

        public AccessTokenResponse build() {
            String encodedToken;
            if (this.accessToken != null) {
                this.audit.detail("token_id", this.accessToken.getId());
            }
            if (this.refreshToken != null) {
                if (this.audit.getEvent().getDetails().containsKey("refresh_token_id")) {
                    this.audit.detail("updated_refresh_token_id", this.refreshToken.getId());
                } else {
                    this.audit.detail("refresh_token_id", this.refreshToken.getId());
                }
            }
            AccessTokenResponse res = new AccessTokenResponse();
            if (this.idToken != null) {
                encodedToken = new JWSBuilder().jsonContent((Object)this.idToken).rsa256(this.realm.getPrivateKey());
                res.setIdToken(encodedToken);
            }
            if (this.accessToken != null) {
                encodedToken = new JWSBuilder().jsonContent((Object)this.accessToken).rsa256(this.realm.getPrivateKey());
                res.setToken(encodedToken);
                res.setTokenType("bearer");
                res.setSessionState(this.accessToken.getSessionState());
                if (this.accessToken.getExpiration() != 0) {
                    res.setExpiresIn((long)(this.accessToken.getExpiration() - Time.currentTime()));
                }
            }
            if (this.refreshToken != null) {
                encodedToken = new JWSBuilder().jsonContent((Object)this.refreshToken).rsa256(this.realm.getPrivateKey());
                res.setRefreshToken(encodedToken);
            }
            int notBefore = this.realm.getNotBefore();
            if (this.client.getNotBefore() > notBefore) {
                notBefore = this.client.getNotBefore();
            }
            res.setNotBeforePolicy(notBefore);
            return res;
        }
    }
}

