/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.net.URI;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.BadRequestException;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.NotAcceptableException;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.UnauthorizedException;
import org.keycloak.OAuthErrorException;
import org.keycloak.audit.Audit;
import org.keycloak.audit.EventType;
import org.keycloak.authentication.AuthenticationProviderException;
import org.keycloak.authentication.AuthenticationProviderManager;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.crypto.RSAProvider;
import org.keycloak.login.LoginFormsProvider;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ProviderSession;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.services.ClientConnection;
import org.keycloak.services.managers.AccessCodeEntry;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.ResourceAdminManager;
import org.keycloak.services.managers.TokenManager;
import org.keycloak.services.resources.Cors;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.services.resources.RequiredActionsService;
import org.keycloak.services.resources.flows.Flows;
import org.keycloak.services.resources.flows.OAuthFlows;
import org.keycloak.services.resources.flows.Urls;
import org.keycloak.services.validation.Validation;
import org.keycloak.util.BasicAuthHelper;
import org.keycloak.util.Time;

public class TokenService {
    protected static final Logger logger = Logger.getLogger(TokenService.class);
    protected RealmModel realm;
    protected TokenManager tokenManager;
    private Audit audit;
    protected AuthenticationManager authManager;
    @Context
    protected Providers providers;
    @Context
    protected SecurityContext securityContext;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected HttpHeaders headers;
    @Context
    protected HttpRequest request;
    @Context
    protected HttpResponse response;
    @Context
    protected KeycloakSession session;
    @Context
    protected KeycloakTransaction transaction;
    @Context
    protected ClientConnection clientConnection;
    @Context
    protected ProviderSession providerSession;
    private ResourceAdminManager resourceAdminManager = new ResourceAdminManager();

    public TokenService(RealmModel realm, TokenManager tokenManager, Audit audit, AuthenticationManager authManager) {
        this.realm = realm;
        this.tokenManager = tokenManager;
        this.audit = audit;
        this.authManager = authManager;
    }

    public static UriBuilder tokenServiceBaseUrl(UriInfo uriInfo) {
        UriBuilder baseUriBuilder = uriInfo.getBaseUriBuilder();
        return TokenService.tokenServiceBaseUrl(baseUriBuilder);
    }

    public static UriBuilder tokenServiceBaseUrl(UriBuilder baseUriBuilder) {
        return baseUriBuilder.path(RealmsResource.class).path(RealmsResource.class, "getTokenService");
    }

    public static UriBuilder accessCodeToTokenUrl(UriInfo uriInfo) {
        UriBuilder baseUriBuilder = uriInfo.getBaseUriBuilder();
        return TokenService.accessCodeToTokenUrl(baseUriBuilder);
    }

    public static UriBuilder accessCodeToTokenUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = TokenService.tokenServiceBaseUrl(baseUriBuilder);
        return uriBuilder.path(TokenService.class, "accessCodeToToken");
    }

    public static UriBuilder grantAccessTokenUrl(UriInfo uriInfo) {
        UriBuilder baseUriBuilder = uriInfo.getBaseUriBuilder();
        return TokenService.grantAccessTokenUrl(baseUriBuilder);
    }

    public static UriBuilder grantAccessTokenUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = TokenService.tokenServiceBaseUrl(baseUriBuilder);
        return uriBuilder.path(TokenService.class, "grantAccessToken");
    }

    public static UriBuilder loginPageUrl(UriInfo uriInfo) {
        UriBuilder baseUriBuilder = uriInfo.getBaseUriBuilder();
        return TokenService.loginPageUrl(baseUriBuilder);
    }

    public static UriBuilder loginPageUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = TokenService.tokenServiceBaseUrl(baseUriBuilder);
        return uriBuilder.path(TokenService.class, "loginPage");
    }

    public static UriBuilder logoutUrl(UriInfo uriInfo) {
        UriBuilder baseUriBuilder = uriInfo.getBaseUriBuilder();
        return TokenService.logoutUrl(baseUriBuilder);
    }

    public static UriBuilder logoutUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = TokenService.tokenServiceBaseUrl(baseUriBuilder);
        return uriBuilder.path(TokenService.class, "logout");
    }

    public static UriBuilder processLoginUrl(UriInfo uriInfo) {
        UriBuilder baseUriBuilder = uriInfo.getBaseUriBuilder();
        return TokenService.processLoginUrl(baseUriBuilder);
    }

    public static UriBuilder processLoginUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = TokenService.tokenServiceBaseUrl(baseUriBuilder);
        return uriBuilder.path(TokenService.class, "processLogin");
    }

    public static UriBuilder processOAuthUrl(UriInfo uriInfo) {
        UriBuilder baseUriBuilder = uriInfo.getBaseUriBuilder();
        return TokenService.processOAuthUrl(baseUriBuilder);
    }

    public static UriBuilder processOAuthUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = TokenService.tokenServiceBaseUrl(baseUriBuilder);
        return uriBuilder.path(TokenService.class, "processOAuth");
    }

    public static UriBuilder refreshUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = TokenService.tokenServiceBaseUrl(baseUriBuilder);
        return uriBuilder.path(TokenService.class, "refreshAccessToken");
    }

    @Path(value="grants/access")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Response grantAccessToken(@HeaderParam(value="Authorization") String authorizationHeader, MultivaluedMap<String, String> form) {
        if (!this.checkSsl()) {
            return this.createError("https_required", "HTTPS required", Response.Status.FORBIDDEN);
        }
        if (!this.realm.isPasswordCredentialGrantAllowed()) {
            return this.createError("not_enabled", "Resource Owner Password Credentials Grant not enabled", Response.Status.FORBIDDEN);
        }
        this.audit.event(EventType.LOGIN).detail("auth_method", "oauth_credentials").detail("response_type", "token");
        String username = (String)form.getFirst((Object)"username");
        if (username == null) {
            this.audit.error("username_missing");
            throw new UnauthorizedException("No username");
        }
        this.audit.detail("username", username);
        UserModel user = this.realm.getUser(username);
        this.audit.user(user);
        ClientModel client = this.authorizeClient(authorizationHeader, form, this.audit);
        if (client instanceof ApplicationModel && ((ApplicationModel)client).isBearerOnly()) {
            this.audit.error("not_allowed");
            return this.createError("not_allowed", "Bearer-only applications are not allowed to invoke grants/access", Response.Status.FORBIDDEN);
        }
        if (!this.realm.isEnabled()) {
            this.audit.error("realm_disabled");
            return this.createError("realm_disabled", "Realm is disabled", Response.Status.UNAUTHORIZED);
        }
        AuthenticationManager.AuthenticationStatus authenticationStatus = this.authManager.authenticateForm(this.clientConnection, this.realm, form);
        switch (authenticationStatus) {
            case SUCCESS: {
                break;
            }
            case ACCOUNT_TEMPORARILY_DISABLED: 
            case ACTIONS_REQUIRED: {
                HashMap<String, String> err = new HashMap<String, String>();
                err.put("error", "invalid_grant");
                err.put("error_description", "AccountProvider temporarily disabled");
                this.audit.error("user_temporarily_disabled");
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(err).build();
            }
            case ACCOUNT_DISABLED: {
                HashMap<String, String> err = new HashMap<String, String>();
                err.put("error", "invalid_grant");
                err.put("error_description", "AccountProvider disabled");
                this.audit.error("user_disabled");
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(err).build();
            }
            default: {
                HashMap<String, String> err = new HashMap<String, String>();
                err.put("error", "invalid_grant");
                err.put("error_description", "Invalid user credentials");
                this.audit.error("invalid_user_credentials");
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(err).build();
            }
        }
        String scope = (String)form.getFirst((Object)"scope");
        UserSessionModel session = this.realm.createUserSession(user, this.clientConnection.getRemoteAddr());
        session.associateClient(client);
        this.audit.session(session);
        AccessTokenResponse res = this.tokenManager.responseBuilder(this.realm, client, this.audit).generateAccessToken(scope, client, user, session).generateRefreshToken().generateIDToken().build();
        this.audit.success();
        return Response.ok((Object)res, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    @Path(value="refresh")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Response refreshAccessToken(@HeaderParam(value="Authorization") String authorizationHeader, MultivaluedMap<String, String> form) {
        AccessToken accessToken;
        logger.info((Object)"--> refreshAccessToken");
        if (!this.checkSsl()) {
            throw new NotAcceptableException("HTTPS required");
        }
        this.audit.event(EventType.REFRESH_TOKEN);
        ClientModel client = this.authorizeClient(authorizationHeader, form, this.audit);
        String refreshToken = (String)form.getFirst((Object)"refresh_token");
        try {
            accessToken = this.tokenManager.refreshAccessToken(this.uriInfo, this.realm, client, refreshToken, this.audit);
        }
        catch (OAuthErrorException e) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", e.getError());
            if (e.getDescription() != null) {
                error.put("error_description", e.getDescription());
            }
            this.audit.error("invalid_token");
            logger.error((Object)"OAuth Error", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type("application/json").build();
        }
        AccessTokenResponse res = this.tokenManager.responseBuilder(this.realm, client, this.audit).accessToken(accessToken).generateIDToken().generateRefreshToken().build();
        this.audit.success();
        return Cors.add(this.request, Response.ok((Object)res, (MediaType)MediaType.APPLICATION_JSON_TYPE)).auth().allowedOrigins(client).allowedMethods("POST").exposedHeaders("Access-Control-Allow-Methods").build();
    }

    @Path(value="auth/request/login")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response processLogin(@QueryParam(value="client_id") String clientId, @QueryParam(value="scope") String scopeParam, @QueryParam(value="state") String state, @QueryParam(value="redirect_uri") String redirect, MultivaluedMap<String, String> formData) {
        logger.debug((Object)"TokenService.processLogin");
        String username = (String)formData.getFirst((Object)"username");
        String rememberMe = (String)formData.getFirst((Object)"rememberMe");
        boolean remember = rememberMe != null && rememberMe.equalsIgnoreCase("on");
        logger.debug((Object)("*** Remember me: " + remember));
        this.audit.event(EventType.LOGIN).client(clientId).detail("redirect_uri", redirect).detail("response_type", "code").detail("auth_method", "form").detail("username", username);
        if (remember) {
            this.audit.detail("remember_me", "true");
        }
        OAuthFlows oauth = Flows.oauth(this.providerSession, this.realm, this.request, this.uriInfo, this.authManager, this.tokenManager);
        if (!this.checkSsl()) {
            return oauth.forwardToSecurityFailure("HTTPS required");
        }
        if (!this.realm.isEnabled()) {
            this.audit.error("realm_disabled");
            return oauth.forwardToSecurityFailure("Realm not enabled.");
        }
        ClientModel client = this.realm.findClient(clientId);
        if (client == null) {
            this.audit.error("client_not_found");
            return oauth.forwardToSecurityFailure("Unknown login requester.");
        }
        if (!client.isEnabled()) {
            this.audit.error("client_not_found");
            return oauth.forwardToSecurityFailure("Login requester not enabled.");
        }
        if ((redirect = TokenService.verifyRedirectUri(this.uriInfo, redirect, this.realm, client)) == null) {
            this.audit.error("invalid_redirect_uri");
            return oauth.forwardToSecurityFailure("Invalid redirect_uri.");
        }
        if (formData.containsKey((Object)"cancel")) {
            this.audit.error("rejected_by_user");
            return oauth.redirectError(client, "access_denied", state, redirect);
        }
        AuthenticationManager.AuthenticationStatus status = this.authManager.authenticateForm(this.clientConnection, this.realm, formData);
        if (remember) {
            this.authManager.createRememberMeCookie(this.realm, this.uriInfo);
        } else {
            AuthenticationManager.expireRememberMeCookie(this.realm, this.uriInfo);
        }
        UserModel user = KeycloakModelUtils.findUserByNameOrEmail((RealmModel)this.realm, (String)username);
        if (user != null) {
            this.audit.user(user);
        }
        switch (status) {
            case SUCCESS: 
            case ACTIONS_REQUIRED: {
                UserSessionModel session = this.realm.createUserSession(user, this.clientConnection.getRemoteAddr());
                this.audit.session(session);
                return oauth.processAccessCode(scopeParam, state, redirect, client, user, session, username, remember, "form", this.audit);
            }
            case ACCOUNT_TEMPORARILY_DISABLED: {
                this.audit.error("user_temporarily_disabled");
                return Flows.forms(this.providerSession, this.realm, this.uriInfo).setError("accountTemporarilyDisabled").setFormData(formData).createLogin();
            }
            case ACCOUNT_DISABLED: {
                this.audit.error("user_disabled");
                return Flows.forms(this.providerSession, this.realm, this.uriInfo).setError("accountDisabled").setFormData(formData).createLogin();
            }
            case MISSING_TOTP: {
                return Flows.forms(this.providerSession, this.realm, this.uriInfo).setFormData(formData).createLoginTotp();
            }
            case INVALID_USER: {
                this.audit.error("user_not_found");
                return Flows.forms(this.providerSession, this.realm, this.uriInfo).setError("invalidUser").setFormData(formData).createLogin();
            }
        }
        this.audit.error("invalid_user_credentials");
        return Flows.forms(this.providerSession, this.realm, this.uriInfo).setError("invalidUser").setFormData(formData).createLogin();
    }

    @Path(value="auth/request/login-actions")
    public RequiredActionsService getRequiredActionsService() {
        RequiredActionsService service = new RequiredActionsService(this.realm, this.tokenManager, this.audit);
        ResteasyProviderFactory.getInstance().injectProperties((Object)service);
        return service;
    }

    @Path(value="registrations")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response processRegister(@QueryParam(value="client_id") String clientId, @QueryParam(value="scope") String scopeParam, @QueryParam(value="state") String state, @QueryParam(value="redirect_uri") String redirect, MultivaluedMap<String, String> formData) {
        String username = (String)formData.getFirst((Object)"username");
        String email = (String)formData.getFirst((Object)"email");
        this.audit.event(EventType.REGISTER).client(clientId).detail("redirect_uri", redirect).detail("response_type", "code").detail("username", username).detail("email", email).detail("register_method", "form");
        OAuthFlows oauth = Flows.oauth(this.providerSession, this.realm, this.request, this.uriInfo, this.authManager, this.tokenManager);
        if (!this.realm.isEnabled()) {
            logger.warn((Object)"Realm not enabled");
            this.audit.error("realm_disabled");
            return oauth.forwardToSecurityFailure("Realm not enabled");
        }
        ClientModel client = this.realm.findClient(clientId);
        if (client == null) {
            logger.warn((Object)"Unknown login requester.");
            this.audit.error("client_not_found");
            return oauth.forwardToSecurityFailure("Unknown login requester.");
        }
        if (!client.isEnabled()) {
            logger.warn((Object)"Login requester not enabled.");
            this.audit.error("client_disabled");
            return oauth.forwardToSecurityFailure("Login requester not enabled.");
        }
        if ((redirect = TokenService.verifyRedirectUri(this.uriInfo, redirect, this.realm, client)) == null) {
            this.audit.error("invalid_redirect_uri");
            return oauth.forwardToSecurityFailure("Invalid redirect_uri.");
        }
        if (!this.realm.isRegistrationAllowed()) {
            logger.warn((Object)"Registration not allowed");
            this.audit.error("registration_disabled");
            return oauth.forwardToSecurityFailure("Registration not allowed");
        }
        LinkedList<String> requiredCredentialTypes = new LinkedList<String>();
        for (RequiredCredentialModel m : this.realm.getRequiredCredentials()) {
            requiredCredentialTypes.add(m.getType());
        }
        String error = Validation.validateRegistrationForm(formData, requiredCredentialTypes);
        if (error == null) {
            error = Validation.validatePassword(formData, this.realm.getPasswordPolicy());
        }
        if (error != null) {
            this.audit.error("invalid_registration");
            return Flows.forms(this.providerSession, this.realm, this.uriInfo).setError(error).setFormData(formData).createRegistration();
        }
        AuthenticationProviderManager authenticationProviderManager = AuthenticationProviderManager.getManager((RealmModel)this.realm, (ProviderSession)this.providerSession);
        if (this.realm.getUser(username) != null || authenticationProviderManager.getUser(username) != null) {
            this.audit.error("username_in_use");
            return Flows.forms(this.providerSession, this.realm, this.uriInfo).setError("usernameExists").setFormData(formData).createRegistration();
        }
        UserModel user = this.realm.addUser(username);
        user.setEnabled(true);
        user.setFirstName((String)formData.getFirst((Object)"firstName"));
        user.setLastName((String)formData.getFirst((Object)"lastName"));
        user.setEmail(email);
        if (requiredCredentialTypes.contains("password")) {
            String passwordUpdateError;
            boolean passwordUpdateSuccessful;
            UserCredentialModel credentials = new UserCredentialModel();
            credentials.setType("password");
            credentials.setValue((String)formData.getFirst((Object)"password"));
            try {
                passwordUpdateSuccessful = AuthenticationProviderManager.getManager((RealmModel)this.realm, (ProviderSession)this.providerSession).updatePassword(user, (String)formData.getFirst((Object)"password"));
                passwordUpdateError = "Password update failed";
            }
            catch (AuthenticationProviderException ape) {
                passwordUpdateSuccessful = false;
                passwordUpdateError = ape.getMessage();
            }
            if (!passwordUpdateSuccessful) {
                user.addRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD);
                return Flows.forms(this.providerSession, this.realm, this.uriInfo).setError(passwordUpdateError).createResponse(UserModel.RequiredAction.UPDATE_PASSWORD);
            }
        }
        this.audit.user(user).success();
        this.audit.reset();
        return this.processLogin(clientId, scopeParam, state, redirect, formData);
    }

    @Path(value="access/codes")
    @OPTIONS
    @Produces(value={"application/json"})
    public Response accessCodeToTokenPreflight() {
        logger.debugv("cors request from: {0}", this.request.getHttpHeaders().getRequestHeaders().getFirst((Object)"Origin"));
        return Cors.add(this.request, Response.ok()).auth().preflight().build();
    }

    @Path(value="access/codes")
    @POST
    @Produces(value={"application/json"})
    public Response accessCodeToToken(@HeaderParam(value="Authorization") String authorizationHeader, MultivaluedMap<String, String> formData) {
        logger.debug((Object)"accessRequest <---");
        if (!this.checkSsl()) {
            throw new NotAcceptableException("HTTPS required");
        }
        this.audit.event(EventType.CODE_TO_TOKEN);
        if (!this.realm.isEnabled()) {
            this.audit.error("realm_disabled");
            throw new UnauthorizedException("Realm not enabled");
        }
        String code = (String)formData.getFirst((Object)"code");
        if (code == null) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", "invalid_request");
            error.put("error_description", "code not specified");
            this.audit.error("invalid_code");
            throw new BadRequestException("Code not specified", Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type("application/json").build());
        }
        JWSInput input = new JWSInput(code);
        boolean verifiedCode = false;
        try {
            verifiedCode = RSAProvider.verify((JWSInput)input, (PublicKey)this.realm.getPublicKey());
        }
        catch (Exception ignored) {
            logger.debug((Object)"Failed to verify signature", (Throwable)ignored);
        }
        if (!verifiedCode) {
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("error", "invalid_grant");
            res.put("error_description", "Unable to verify code signature");
            this.audit.error("invalid_code");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(res).build();
        }
        String key = input.readContentAsString();
        this.audit.detail("code_id", key);
        AccessCodeEntry accessCode = this.tokenManager.pullAccessCode(key);
        if (accessCode == null) {
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("error", "invalid_grant");
            res.put("error_description", "Code not found");
            this.audit.error("invalid_code");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(res).build();
        }
        this.audit.user(accessCode.getUser());
        this.audit.session(accessCode.getSessionState());
        ClientModel client = this.authorizeClient(authorizationHeader, formData, this.audit);
        if (accessCode.isExpired()) {
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("error", "invalid_grant");
            res.put("error_description", "Code is expired");
            this.audit.error("invalid_code");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(res).build();
        }
        if (!accessCode.getToken().isActive()) {
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("error", "invalid_grant");
            res.put("error_description", "Token expired");
            this.audit.error("invalid_code");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(res).build();
        }
        if (!client.getClientId().equals(accessCode.getClient().getClientId())) {
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("error", "invalid_grant");
            res.put("error_description", "Auth error");
            this.audit.error("invalid_code");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(res).build();
        }
        UserModel user = this.realm.getUserById(accessCode.getUser().getId());
        if (user == null) {
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("error", "invalid_grant");
            res.put("error_description", "User not found");
            this.audit.error("invalid_code");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(res).build();
        }
        if (!user.isEnabled()) {
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("error", "invalid_grant");
            res.put("error_description", "User disabled");
            this.audit.error("invalid_code");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(res).build();
        }
        UserSessionModel session = this.realm.getUserSession(accessCode.getSessionState());
        if (!AuthenticationManager.isSessionValid(this.realm, session)) {
            AuthenticationManager.logout(this.realm, session, this.uriInfo);
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("error", "invalid_grant");
            res.put("error_description", "Session not active");
            this.audit.error("invalid_code");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(res).build();
        }
        logger.debug((Object)"accessRequest SUCCESS");
        session.associateClient(client);
        AccessTokenResponse res = this.tokenManager.responseBuilder(this.realm, client, this.audit).accessToken(accessCode.getToken()).generateIDToken().generateRefreshToken().build();
        this.audit.success();
        return Cors.add(this.request, Response.ok((Object)res)).auth().allowedOrigins(client).allowedMethods("POST").exposedHeaders("Access-Control-Allow-Methods").build();
    }

    protected ClientModel authorizeClient(String authorizationHeader, MultivaluedMap<String, String> formData, Audit audit) {
        String clientSecret;
        String client_id;
        if (authorizationHeader != null) {
            String[] usernameSecret = BasicAuthHelper.parseHeader((String)authorizationHeader);
            if (usernameSecret == null) {
                throw new UnauthorizedException("Bad Authorization header", Response.status((int)401).header("WWW-Authenticate", (Object)("Basic realm=\"" + this.realm.getName() + "\"")).build());
            }
            client_id = usernameSecret[0];
            clientSecret = usernameSecret[1];
        } else {
            logger.info((Object)"no authorization header");
            client_id = (String)formData.getFirst((Object)"client_id");
            clientSecret = (String)formData.getFirst((Object)"client_secret");
        }
        if (client_id == null) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", "invalid_client");
            error.put("error_description", "Could not find client");
            throw new BadRequestException("Could not find client", Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type("application/json").build());
        }
        audit.client(client_id);
        ClientModel client = this.realm.findClient(client_id);
        if (client == null) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", "invalid_client");
            error.put("error_description", "Could not find client");
            audit.error("client_not_found");
            throw new BadRequestException("Could not find client", Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type("application/json").build());
        }
        if (!client.isEnabled()) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", "invalid_client");
            error.put("error_description", "Client is not enabled");
            audit.error("client_disabled");
            throw new BadRequestException("Client is not enabled", Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type("application/json").build());
        }
        if (!client.isPublicClient() && !client.validateSecret(clientSecret)) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("error", "unauthorized_client");
            audit.error("invalid_client_credentials");
            throw new BadRequestException("Unauthorized Client", Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(error).type("application/json").build());
        }
        return client;
    }

    @Path(value="login")
    @GET
    public Response loginPage(@QueryParam(value="response_type") String responseType, @QueryParam(value="redirect_uri") String redirect, @QueryParam(value="client_id") String clientId, @QueryParam(value="scope") String scopeParam, @QueryParam(value="state") String state, @QueryParam(value="prompt") String prompt) {
        logger.info((Object)"TokenService.loginPage");
        this.audit.event(EventType.LOGIN).client(clientId).detail("redirect_uri", redirect).detail("response_type", "code");
        OAuthFlows oauth = Flows.oauth(this.providerSession, this.realm, this.request, this.uriInfo, this.authManager, this.tokenManager);
        if (!this.checkSsl()) {
            return oauth.forwardToSecurityFailure("HTTPS required");
        }
        if (!this.realm.isEnabled()) {
            logger.warn((Object)"Realm not enabled");
            this.audit.error("realm_disabled");
            return oauth.forwardToSecurityFailure("Realm not enabled");
        }
        ClientModel client = this.realm.findClient(clientId);
        if (client == null) {
            logger.warn((Object)("Unknown login requester: " + clientId));
            this.audit.error("client_not_found");
            return oauth.forwardToSecurityFailure("Unknown login requester.");
        }
        if (!client.isEnabled()) {
            logger.warn((Object)"Login requester not enabled.");
            this.audit.error("client_disabled");
            return oauth.forwardToSecurityFailure("Login requester not enabled.");
        }
        if (client instanceof ApplicationModel && ((ApplicationModel)client).isBearerOnly()) {
            this.audit.error("not_allowed");
            return oauth.forwardToSecurityFailure("Bearer-only applications are not allowed to initiate browser login");
        }
        if (client.isDirectGrantsOnly()) {
            this.audit.error("not_allowed");
            return oauth.forwardToSecurityFailure("direct-grants-only clients are not allowed to initiate browser login");
        }
        if ((redirect = TokenService.verifyRedirectUri(this.uriInfo, redirect, this.realm, client)) == null) {
            this.audit.error("invalid_redirect_uri");
            return oauth.forwardToSecurityFailure("Invalid redirect_uri.");
        }
        logger.info((Object)"Checking cookie...");
        AuthenticationManager.AuthResult authResult = this.authManager.authenticateIdentityCookie(this.realm, this.uriInfo, this.headers);
        if (authResult != null) {
            UserModel user = authResult.getUser();
            UserSessionModel session = authResult.getSession();
            logger.debug((Object)(user.getLoginName() + " already logged in."));
            this.audit.user(user).session(session).detail("auth_method", "sso");
            return oauth.processAccessCode(scopeParam, state, redirect, client, user, session, null, false, "sso", this.audit);
        }
        if (prompt != null && prompt.equals("none")) {
            return oauth.redirectError(client, "access_denied", state, redirect);
        }
        logger.info((Object)"createLogin() now...");
        return Flows.forms(this.providerSession, this.realm, this.uriInfo).createLogin();
    }

    @Path(value="registrations")
    @GET
    public Response registerPage(@QueryParam(value="response_type") String responseType, @QueryParam(value="redirect_uri") String redirect, @QueryParam(value="client_id") String clientId, @QueryParam(value="scope") String scopeParam, @QueryParam(value="state") String state) {
        logger.info((Object)"**********registerPage()");
        this.audit.event(EventType.REGISTER).client(clientId).detail("redirect_uri", redirect).detail("response_type", "code");
        OAuthFlows oauth = Flows.oauth(this.providerSession, this.realm, this.request, this.uriInfo, this.authManager, this.tokenManager);
        if (!this.checkSsl()) {
            return oauth.forwardToSecurityFailure("HTTPS required");
        }
        if (!this.realm.isEnabled()) {
            logger.warn((Object)"Realm not enabled");
            this.audit.error("realm_disabled");
            return oauth.forwardToSecurityFailure("Realm not enabled");
        }
        ClientModel client = this.realm.findClient(clientId);
        if (client == null) {
            logger.warn((Object)"Unknown login requester.");
            this.audit.error("client_not_found");
            return oauth.forwardToSecurityFailure("Unknown login requester.");
        }
        if (!client.isEnabled()) {
            logger.warn((Object)"Login requester not enabled.");
            this.audit.error("client_disabled");
            return oauth.forwardToSecurityFailure("Login requester not enabled.");
        }
        if ((redirect = TokenService.verifyRedirectUri(this.uriInfo, redirect, this.realm, client)) == null) {
            this.audit.error("invalid_redirect_uri");
            return oauth.forwardToSecurityFailure("Invalid redirect_uri.");
        }
        if (!this.realm.isRegistrationAllowed()) {
            logger.warn((Object)"Registration not allowed");
            this.audit.error("registration_disabled");
            return oauth.forwardToSecurityFailure("Registration not allowed");
        }
        AuthenticationManager.expireIdentityCookie(this.realm, this.uriInfo);
        return Flows.forms(this.providerSession, this.realm, this.uriInfo).createRegistration();
    }

    @Path(value="logout")
    @GET
    @NoCache
    public Response logout(@QueryParam(value="session_state") String sessionState, @QueryParam(value="redirect_uri") String redirectUri) {
        AuthenticationManager.AuthResult authResult;
        this.audit.event(EventType.LOGOUT);
        if (redirectUri != null) {
            this.audit.detail("redirect_uri", redirectUri);
        }
        if (sessionState != null) {
            this.audit.session(sessionState);
        }
        if ((authResult = this.authManager.authenticateIdentityCookie(this.realm, this.uriInfo, this.headers, false)) != null) {
            this.logout(authResult.getSession());
        } else if (sessionState != null) {
            UserSessionModel userSession = this.realm.getUserSession(sessionState);
            if (userSession != null) {
                this.logout(userSession);
            } else {
                this.audit.error("user_session_not_found");
            }
        } else {
            this.audit.error("user_not_logged_in");
        }
        if (redirectUri != null) {
            return Response.status((int)302).location(UriBuilder.fromUri((String)redirectUri).build(new Object[0])).build();
        }
        return Response.ok().build();
    }

    private void logout(UserSessionModel session) {
        UserModel user = session.getUser();
        AuthenticationManager.logout(this.realm, session, this.uriInfo);
        this.audit.user(user).session(session).success();
    }

    @Path(value="oauth/grant")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response processOAuth(MultivaluedMap<String, String> formData) {
        UserSessionModel session;
        this.audit.event(EventType.LOGIN).detail("response_type", "code");
        OAuthFlows oauth = Flows.oauth(this.providerSession, this.realm, this.request, this.uriInfo, this.authManager, this.tokenManager);
        if (!this.checkSsl()) {
            return oauth.forwardToSecurityFailure("HTTPS required");
        }
        String code = (String)formData.getFirst((Object)"code");
        JWSInput input = new JWSInput(code);
        boolean verifiedCode = false;
        try {
            verifiedCode = RSAProvider.verify((JWSInput)input, (PublicKey)this.realm.getPublicKey());
        }
        catch (Exception ignored) {
            logger.debug((Object)"Failed to verify signature", (Throwable)ignored);
        }
        if (!verifiedCode) {
            this.audit.error("invalid_code");
            return oauth.forwardToSecurityFailure("Illegal access code.");
        }
        String key = input.readContentAsString();
        this.audit.detail("code_id", key);
        AccessCodeEntry accessCodeEntry = this.tokenManager.getAccessCode(key);
        if (accessCodeEntry == null) {
            this.audit.error("invalid_code");
            return oauth.forwardToSecurityFailure("Unknown access code.");
        }
        String redirect = accessCodeEntry.getRedirectUri();
        String state = accessCodeEntry.getState();
        this.audit.client(accessCodeEntry.getClient()).user(accessCodeEntry.getUser()).detail("response_type", "code").detail("auth_method", accessCodeEntry.getAuthMethod()).detail("redirect_uri", redirect).detail("username", accessCodeEntry.getUsername());
        if (accessCodeEntry.isRememberMe()) {
            this.audit.detail("remember_me", "true");
        }
        if (!AuthenticationManager.isSessionValid(this.realm, session = this.realm.getUserSession(accessCodeEntry.getSessionState()))) {
            AuthenticationManager.logout(this.realm, session, this.uriInfo);
            this.audit.error("invalid_code");
            return oauth.forwardToSecurityFailure("Session not active");
        }
        this.audit.session(session);
        if (formData.containsKey((Object)"cancel")) {
            this.audit.error("rejected_by_user");
            return this.redirectAccessDenied(redirect, state);
        }
        this.audit.success();
        accessCodeEntry.setExpiration(Time.currentTime() + this.realm.getAccessCodeLifespan());
        return oauth.redirectAccessCode(accessCodeEntry, session, state, redirect);
    }

    @Path(value="oauth/oob")
    @GET
    public Response installedAppUrnCallback(@QueryParam(value="code") String code, @QueryParam(value="error") String error, @QueryParam(value="error_description") String errorDescription) {
        LoginFormsProvider forms = Flows.forms(this.providerSession, this.realm, this.uriInfo);
        if (code != null) {
            return forms.setAccessCode(null, code).createCode();
        }
        return forms.setError(error).createCode();
    }

    protected Response redirectAccessDenied(String redirect, String state) {
        UriBuilder redirectUri = UriBuilder.fromUri((String)redirect).queryParam("error", new Object[]{"access_denied"});
        if (state != null) {
            redirectUri.queryParam("state", new Object[]{state});
        }
        Response.ResponseBuilder location = Response.status((int)302).location(redirectUri.build(new Object[0]));
        return location.build();
    }

    public static boolean matchesRedirects(Set<String> validRedirects, String redirect) {
        for (String validRedirect : validRedirects) {
            if (validRedirect.endsWith("*")) {
                int length = validRedirect.length() - 1;
                if (redirect.startsWith(validRedirect = validRedirect.substring(0, length))) {
                    return true;
                }
                if (length - 1 > 0 && validRedirect.charAt(length - 1) == '/') {
                    --length;
                }
                if (!(validRedirect = validRedirect.substring(0, length)).equals(redirect)) continue;
                return true;
            }
            if (!validRedirect.equals(redirect)) continue;
            return true;
        }
        return false;
    }

    public static String verifyRedirectUri(UriInfo uriInfo, String redirectUri, RealmModel realm, ClientModel client) {
        Set validRedirects = client.getRedirectUris();
        if (redirectUri == null) {
            if (validRedirects.size() != 1) {
                return null;
            }
            String validRedirect = (String)validRedirects.iterator().next();
            int idx = validRedirect.indexOf("/*");
            if (idx > -1) {
                validRedirect = validRedirect.substring(0, idx);
            }
            redirectUri = validRedirect;
        } else if (validRedirects.isEmpty()) {
            logger.error((Object)("Redirect URI is required for client: " + client.getClientId()));
            redirectUri = null;
        } else {
            String r = redirectUri.indexOf(63) != -1 ? redirectUri.substring(0, redirectUri.indexOf(63)) : redirectUri;
            Set<String> resolveValidRedirects = TokenService.resolveValidRedirects(uriInfo, validRedirects);
            boolean valid = TokenService.matchesRedirects(resolveValidRedirects, r);
            if (!valid && r.startsWith("http://localhost") && r.indexOf(58, "http://localhost".length()) >= 0) {
                int i = r.indexOf(58, "http://localhost".length());
                StringBuilder sb = new StringBuilder();
                sb.append(r.substring(0, i));
                i = r.indexOf(47, i);
                if (i >= 0) {
                    sb.append(r.substring(i));
                }
                r = sb.toString();
                valid = TokenService.matchesRedirects(resolveValidRedirects, r);
            }
            String string = redirectUri = valid ? redirectUri : null;
        }
        if ("urn:ietf:wg:oauth:2.0:oob".equals(redirectUri)) {
            return Urls.realmInstalledAppUrnCallback(uriInfo.getBaseUri(), realm.getName()).toString();
        }
        return redirectUri;
    }

    public static Set<String> resolveValidRedirects(UriInfo uriInfo, Set<String> validRedirects) {
        HashSet<String> resolveValidRedirects = new HashSet<String>();
        for (String validRedirect : validRedirects) {
            if (validRedirect.startsWith("/")) {
                URI baseUri = uriInfo.getBaseUri();
                String uri = baseUri.getScheme() + "://" + baseUri.getHost();
                if (baseUri.getPort() != -1) {
                    uri = uri + ":" + baseUri.getPort();
                }
                validRedirect = uri + validRedirect;
                logger.debugv("replacing relative valid redirect with: {0}", (Object)validRedirect);
            }
            resolveValidRedirects.add(validRedirect);
        }
        return resolveValidRedirects;
    }

    private boolean checkSsl() {
        return this.realm.isSslNotRequired() || this.uriInfo.getBaseUri().getScheme().equals("https");
    }

    private Response createError(String error, String errorDescription, Response.Status status) {
        HashMap<String, String> e = new HashMap<String, String>();
        e.put("error", error);
        if (errorDescription != null) {
            e.put("error_description", errorDescription);
        }
        return Response.status((Response.Status)status).entity(e).type("application/json").build();
    }
}

