/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.exportimport;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.exportimport.ExportImportPropertiesManager;
import org.keycloak.exportimport.io.ExportWriter;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.AuthenticationLinkModel;
import org.keycloak.models.AuthenticationProviderModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OAuthClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.SocialLinkModel;
import org.keycloak.models.UserCredentialValueModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UsernameLoginFailureModel;
import org.keycloak.models.entities.ApplicationEntity;
import org.keycloak.models.entities.AuthenticationLinkEntity;
import org.keycloak.models.entities.AuthenticationProviderEntity;
import org.keycloak.models.entities.CredentialEntity;
import org.keycloak.models.entities.OAuthClientEntity;
import org.keycloak.models.entities.RealmEntity;
import org.keycloak.models.entities.RequiredCredentialEntity;
import org.keycloak.models.entities.RoleEntity;
import org.keycloak.models.entities.SocialLinkEntity;
import org.keycloak.models.entities.UserEntity;
import org.keycloak.models.entities.UsernameLoginFailureEntity;

public class ModelExporter {
    private static final Logger logger = Logger.getLogger(ModelExporter.class);
    private ExportWriter exportWriter;
    private ExportImportPropertiesManager propertiesManager;

    public void exportModel(KeycloakSession keycloakSession, ExportWriter exportWriter) {
        this.exportWriter = exportWriter;
        this.propertiesManager = new ExportImportPropertiesManager();
        this.exportRealms(keycloakSession, "realms.json");
        this.exportApplications(keycloakSession, "applications.json");
        this.exportOAuthClients(keycloakSession, "oauthClients.json");
        this.exportRoles(keycloakSession, "roles.json");
        this.exportUsers(keycloakSession, "users.json");
        this.exportUserFailures(keycloakSession, "userFailures.json");
        this.exportWriter.closeExportWriter();
    }

    protected void exportRealms(KeycloakSession keycloakSession, String fileName) {
        List realms = keycloakSession.getRealms();
        LinkedList<RealmEntity> result = new LinkedList<RealmEntity>();
        for (RealmModel realmModel : realms) {
            RealmEntity entity = new RealmEntity();
            entity.setId(realmModel.getId());
            result.add(entity);
            this.propertiesManager.setBasicPropertiesFromModel(realmModel, entity);
            ApplicationModel realmAdminApp = realmModel.getMasterAdminApp();
            if (realmAdminApp != null) {
                entity.setAdminAppId(realmAdminApp.getId());
            }
            entity.setDefaultRoles(realmModel.getDefaultRoles());
            ArrayList<RequiredCredentialEntity> reqCredEntities = new ArrayList<RequiredCredentialEntity>();
            List requiredCredModels = realmModel.getRequiredCredentials();
            for (RequiredCredentialModel requiredCredModel : requiredCredModels) {
                RequiredCredentialEntity reqCredEntity = new RequiredCredentialEntity();
                this.propertiesManager.setBasicPropertiesFromModel(requiredCredModel, reqCredEntity);
                reqCredEntities.add(reqCredEntity);
            }
            entity.setRequiredCredentials(reqCredEntities);
            entity.setPasswordPolicy(realmModel.getPasswordPolicy().toString());
            ArrayList<AuthenticationProviderEntity> authProviderEntities = new ArrayList<AuthenticationProviderEntity>();
            for (AuthenticationProviderModel authProvider : realmModel.getAuthenticationProviders()) {
                AuthenticationProviderEntity authProviderEntity = new AuthenticationProviderEntity();
                this.propertiesManager.setBasicPropertiesFromModel(authProvider, authProviderEntity);
                authProviderEntities.add(authProviderEntity);
            }
            entity.setAuthenticationProviders(authProviderEntities);
        }
        this.exportWriter.writeEntities(fileName, result);
        logger.infof("Realms exported: " + result, new Object[0]);
    }

    protected void exportApplications(KeycloakSession keycloakSession, String fileName) {
        List<ApplicationModel> allApplications = this.getAllApplications(keycloakSession);
        LinkedList<ApplicationEntity> result = new LinkedList<ApplicationEntity>();
        for (ApplicationModel appModel : allApplications) {
            ApplicationEntity appEntity = new ApplicationEntity();
            appEntity.setId(appModel.getId());
            result.add(appEntity);
            this.propertiesManager.setBasicPropertiesFromModel(appModel, appEntity);
            appEntity.setRealmId(appModel.getRealm().getId());
            appEntity.setDefaultRoles(appModel.getDefaultRoles());
            List<String> scopeIds = this.getScopeIds((ClientModel)appModel);
            appEntity.setScopeIds(scopeIds);
        }
        this.exportWriter.writeEntities(fileName, result);
        logger.infof("Applications exported: " + result, new Object[0]);
    }

    protected void exportOAuthClients(KeycloakSession keycloakSession, String fileName) {
        List realms = keycloakSession.getRealms();
        ArrayList allClients = new ArrayList();
        for (RealmModel realmModel : realms) {
            allClients.addAll(realmModel.getOAuthClients());
        }
        LinkedList<OAuthClientEntity> result = new LinkedList<OAuthClientEntity>();
        for (OAuthClientModel clientModel : allClients) {
            OAuthClientEntity clientEntity = new OAuthClientEntity();
            clientEntity.setId(clientModel.getId());
            result.add(clientEntity);
            this.propertiesManager.setBasicPropertiesFromModel(clientModel, clientEntity);
            clientEntity.setName(clientModel.getClientId());
            clientEntity.setRealmId(clientModel.getRealm().getId());
            List<String> scopeIds = this.getScopeIds((ClientModel)clientModel);
            clientEntity.setScopeIds(scopeIds);
        }
        this.exportWriter.writeEntities(fileName, result);
        logger.infof("OAuth clients exported: " + result, new Object[0]);
    }

    protected void exportRoles(KeycloakSession keycloakSession, String fileName) {
        List<RoleModel> allRoles = this.getAllRoles(keycloakSession);
        LinkedList<RoleEntity> result = new LinkedList<RoleEntity>();
        for (RoleModel roleModel : allRoles) {
            RoleEntity roleEntity = new RoleEntity();
            roleEntity.setId(roleModel.getId());
            result.add(roleEntity);
            roleEntity.setName(roleModel.getName());
            roleEntity.setDescription(roleModel.getDescription());
            RoleContainerModel roleContainer = roleModel.getContainer();
            if (roleContainer instanceof RealmModel) {
                RealmModel realm = (RealmModel)roleContainer;
                roleEntity.setRealmId(realm.getId());
            } else {
                ApplicationModel appModel = (ApplicationModel)roleContainer;
                roleEntity.setApplicationId(appModel.getId());
            }
            ArrayList<String> compositeRolesIds = null;
            for (RoleModel composite : roleModel.getComposites()) {
                if (compositeRolesIds == null) {
                    compositeRolesIds = new ArrayList<String>();
                }
                compositeRolesIds.add(composite.getId());
            }
            roleEntity.setCompositeRoleIds(compositeRolesIds);
        }
        this.exportWriter.writeEntities(fileName, result);
        logger.infof("%d roles exported: ", (Object)result.size());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Exported roles: " + result));
        }
    }

    protected void exportUsers(KeycloakSession keycloakSession, String fileName) {
        List realms = keycloakSession.getRealms();
        LinkedList<UserEntity> result = new LinkedList<UserEntity>();
        for (RealmModel realm : realms) {
            List userModels = realm.getUsers();
            for (UserModel userModel : userModels) {
                Set requiredActions;
                Set socialLinks;
                UserEntity userEntity = new UserEntity();
                userEntity.setId(userModel.getId());
                result.add(userEntity);
                this.propertiesManager.setBasicPropertiesFromModel(userModel, userEntity);
                userEntity.setLoginName(userModel.getLoginName());
                userEntity.setRealmId(realm.getId());
                AuthenticationLinkModel authLink = userModel.getAuthenticationLink();
                if (authLink != null) {
                    AuthenticationLinkEntity authLinkEntity = new AuthenticationLinkEntity();
                    this.propertiesManager.setBasicPropertiesFromModel(authLink, authLinkEntity);
                    userEntity.setAuthenticationLink(authLinkEntity);
                }
                if ((socialLinks = realm.getSocialLinks(userModel)) != null && !socialLinks.isEmpty()) {
                    ArrayList<SocialLinkEntity> socialLinkEntities = new ArrayList<SocialLinkEntity>();
                    for (SocialLinkModel socialLink : socialLinks) {
                        SocialLinkEntity socialLinkEntity = new SocialLinkEntity();
                        this.propertiesManager.setBasicPropertiesFromModel(socialLink, socialLinkEntity);
                        socialLinkEntities.add(socialLinkEntity);
                    }
                    userEntity.setSocialLinks(socialLinkEntities);
                }
                if ((requiredActions = userModel.getRequiredActions()) != null && !requiredActions.isEmpty()) {
                    userEntity.setRequiredActions(new ArrayList(requiredActions));
                }
                userEntity.setAttributes(userModel.getAttributes());
                Set roles = userModel.getRoleMappings();
                ArrayList<String> roleIds = new ArrayList<String>();
                for (RoleModel role : roles) {
                    roleIds.add(role.getId());
                }
                userEntity.setRoleIds(roleIds);
                List credentials = userModel.getCredentialsDirectly();
                ArrayList<CredentialEntity> credEntities = new ArrayList<CredentialEntity>();
                for (UserCredentialValueModel credModel : credentials) {
                    CredentialEntity credEntity = new CredentialEntity();
                    this.propertiesManager.setBasicPropertiesFromModel(credModel, credEntity);
                    credEntities.add(credEntity);
                }
                userEntity.setCredentials(credEntities);
            }
        }
        this.exportWriter.writeEntities(fileName, result);
        logger.infof("%d users exported: ", (Object)result.size());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Exported users: " + result));
        }
    }

    protected void exportUserFailures(KeycloakSession keycloakSession, String fileName) {
        List realms = keycloakSession.getRealms();
        ArrayList allFailures = new ArrayList();
        for (RealmModel realmModel : realms) {
            allFailures.addAll(realmModel.getAllUserLoginFailures());
        }
        LinkedList<UsernameLoginFailureEntity> result = new LinkedList<UsernameLoginFailureEntity>();
        for (UsernameLoginFailureModel failureModel : allFailures) {
            UsernameLoginFailureEntity failureEntity = new UsernameLoginFailureEntity();
            this.propertiesManager.setBasicPropertiesFromModel(failureModel, failureEntity);
            result.add(failureEntity);
            failureEntity.setUsername(failureModel.getUsername());
            failureEntity.setNumFailures(failureModel.getNumFailures());
        }
        this.exportWriter.writeEntities(fileName, result);
    }

    private List<String> getScopeIds(ClientModel clientModel) {
        Set allScopes = clientModel.getScopeMappings();
        ArrayList<String> scopeIds = new ArrayList<String>();
        for (RoleModel role : allScopes) {
            scopeIds.add(role.getId());
        }
        return scopeIds;
    }

    private List<ApplicationModel> getAllApplications(KeycloakSession keycloakSession) {
        List realms = keycloakSession.getRealms();
        ArrayList<ApplicationModel> allApplications = new ArrayList<ApplicationModel>();
        for (RealmModel realmModel : realms) {
            allApplications.addAll(realmModel.getApplications());
        }
        return allApplications;
    }

    private List<RoleModel> getAllRoles(KeycloakSession keycloakSession) {
        ArrayList<RoleModel> allRoles = new ArrayList<RoleModel>();
        List realms = keycloakSession.getRealms();
        for (RealmModel realmModel : realms) {
            allRoles.addAll(realmModel.getRoles());
        }
        List<ApplicationModel> allApplications = this.getAllApplications(keycloakSession);
        for (ApplicationModel appModel : allApplications) {
            allRoles.addAll(appModel.getRoles());
        }
        return allRoles;
    }
}

