/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.exportimport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.exportimport.ExportImportPropertiesManager;
import org.keycloak.exportimport.io.ImportReader;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.AuthenticationLinkModel;
import org.keycloak.models.AuthenticationProviderModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OAuthClientModel;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.SocialLinkModel;
import org.keycloak.models.UserCredentialValueModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UsernameLoginFailureModel;
import org.keycloak.models.entities.ApplicationEntity;
import org.keycloak.models.entities.AuthenticationLinkEntity;
import org.keycloak.models.entities.AuthenticationProviderEntity;
import org.keycloak.models.entities.ClientEntity;
import org.keycloak.models.entities.CredentialEntity;
import org.keycloak.models.entities.OAuthClientEntity;
import org.keycloak.models.entities.RealmEntity;
import org.keycloak.models.entities.RequiredCredentialEntity;
import org.keycloak.models.entities.RoleEntity;
import org.keycloak.models.entities.SocialLinkEntity;
import org.keycloak.models.entities.UserEntity;
import org.keycloak.models.entities.UsernameLoginFailureEntity;

public class ModelImporter {
    private static final Logger logger = Logger.getLogger(ModelImporter.class);
    private ImportReader importReader;
    private ExportImportPropertiesManager propertiesManager;

    public void importModel(KeycloakSession keycloakSession, ImportReader importReader) {
        this.importReader = importReader;
        this.propertiesManager = new ExportImportPropertiesManager();
        keycloakSession.removeAllData();
        this.importRealms(keycloakSession, "realms.json");
        this.importApplications(keycloakSession, "applications.json");
        this.importRoles(keycloakSession, "roles.json");
        this.importRealmsStep2(keycloakSession, "realms.json");
        this.importApplicationsStep2(keycloakSession, "applications.json");
        this.importOAuthClients(keycloakSession, "oauthClients.json");
        this.importUsers(keycloakSession, "users.json");
        this.importUserFailures(keycloakSession, "userFailures.json");
        this.importReader.closeImportReader();
    }

    protected void importRealms(KeycloakSession keycloakSession, String fileName) {
        List<RealmEntity> realms = this.importReader.readEntities(fileName, RealmEntity.class);
        for (RealmEntity realmEntity : realms) {
            RealmModel realm = keycloakSession.createRealm(realmEntity.getId(), realmEntity.getName());
            this.propertiesManager.setBasicPropertiesToModel(realm, realmEntity);
            HashSet<String> reqCredModels = new HashSet<String>();
            for (RequiredCredentialEntity requiredCredEntity : realmEntity.getRequiredCredentials()) {
                reqCredModels.add(requiredCredEntity.getType());
            }
            realm.updateRequiredCredentials(reqCredModels);
            realm.setPasswordPolicy(new PasswordPolicy(realmEntity.getPasswordPolicy()));
            ArrayList<AuthenticationProviderModel> authProviderModels = new ArrayList<AuthenticationProviderModel>();
            for (AuthenticationProviderEntity authProviderEntity : realmEntity.getAuthenticationProviders()) {
                AuthenticationProviderModel authProvider = new AuthenticationProviderModel();
                this.propertiesManager.setBasicPropertiesToModel(authProvider, authProviderEntity);
                authProviderModels.add(authProvider);
            }
            realm.setAuthenticationProviders(authProviderModels);
        }
        logger.infof("Realms imported: " + realms, new Object[0]);
    }

    protected void importApplications(KeycloakSession keycloakSession, String fileName) {
        List<ApplicationEntity> apps = this.importReader.readEntities(fileName, ApplicationEntity.class);
        for (ApplicationEntity appEntity : apps) {
            RealmModel realm = keycloakSession.getRealm(appEntity.getRealmId());
            ApplicationModel app = realm.addApplication(appEntity.getId(), appEntity.getName());
            this.propertiesManager.setBasicPropertiesToModel(app, appEntity);
        }
        logger.infof("Applications imported: " + apps, new Object[0]);
    }

    protected void importRoles(KeycloakSession keycloakSession, String fileName) {
        HashMap<String, RoleEntity> rolesMap = new HashMap<String, RoleEntity>();
        List<RoleEntity> roles = this.importReader.readEntities(fileName, RoleEntity.class);
        for (RoleEntity roleEntity : roles) {
            RoleModel role = null;
            if (roleEntity.getRealmId() != null) {
                RealmModel realm = keycloakSession.getRealm(roleEntity.getRealmId());
                role = realm.addRole(roleEntity.getId(), roleEntity.getName());
            } else if (roleEntity.getApplicationId() != null) {
                ApplicationModel app = this.findApplicationById(keycloakSession, roleEntity.getApplicationId());
                role = app.addRole(roleEntity.getId(), roleEntity.getName());
            } else {
                throw new IllegalStateException("Role " + roleEntity.getId() + " doesn't have realmId nor applicationId");
            }
            role.setDescription(roleEntity.getDescription());
            rolesMap.put(roleEntity.getId(), roleEntity);
        }
        for (RealmModel realm : keycloakSession.getRealms()) {
            this.fillCompositeRoles(rolesMap, (RoleContainerModel)realm, realm);
            for (ApplicationModel app : realm.getApplications()) {
                this.fillCompositeRoles(rolesMap, (RoleContainerModel)app, realm);
            }
        }
        logger.infof("%d roles imported: ", (Object)roles.size());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Imported roles: " + roles));
        }
    }

    private void fillCompositeRoles(Map<String, RoleEntity> rolesMap, RoleContainerModel roleContainer, RealmModel realm) {
        for (RoleModel role : roleContainer.getRoles()) {
            RoleEntity roleEntity = rolesMap.get(role.getId());
            if (roleEntity.getCompositeRoleIds() == null) continue;
            for (String compositeRoleId : roleEntity.getCompositeRoleIds()) {
                RoleModel compositeRole = realm.getRoleById(compositeRoleId);
                role.addCompositeRole(compositeRole);
            }
        }
    }

    protected void importRealmsStep2(KeycloakSession keycloakSession, String fileName) {
        List<RealmEntity> realms = this.importReader.readEntities(fileName, RealmEntity.class);
        RealmModel adminRealm = keycloakSession.getRealm(Config.getAdminRealm());
        for (RealmEntity realmEntity : realms) {
            RealmModel realm = keycloakSession.getRealm(realmEntity.getId());
            String adminAppId = realmEntity.getAdminAppId();
            if (adminAppId != null) {
                realm.setMasterAdminApp(adminRealm.getApplicationById(adminAppId));
            }
            realm.updateDefaultRoles(realmEntity.getDefaultRoles().toArray(new String[0]));
        }
    }

    protected void importApplicationsStep2(KeycloakSession keycloakSession, String fileName) {
        List<ApplicationEntity> apps = this.importReader.readEntities(fileName, ApplicationEntity.class);
        for (ApplicationEntity appEntity : apps) {
            RealmModel realm = keycloakSession.getRealm(appEntity.getRealmId());
            ApplicationModel application = realm.getApplicationById(appEntity.getId());
            application.updateDefaultRoles(appEntity.getDefaultRoles().toArray(new String[0]));
            this.addScopes(realm, (ClientModel)application, (ClientEntity)appEntity);
        }
    }

    private void addScopes(RealmModel realm, ClientModel client, ClientEntity clientEntity) {
        for (String scopeId : clientEntity.getScopeIds()) {
            RoleModel scope = realm.getRoleById(scopeId);
            client.addScopeMapping(scope);
        }
    }

    protected void importOAuthClients(KeycloakSession keycloakSession, String fileName) {
        List<OAuthClientEntity> clients = this.importReader.readEntities(fileName, OAuthClientEntity.class);
        for (OAuthClientEntity clientEntity : clients) {
            RealmModel realm = keycloakSession.getRealm(clientEntity.getRealmId());
            OAuthClientModel client = realm.addOAuthClient(clientEntity.getId(), clientEntity.getName());
            this.propertiesManager.setBasicPropertiesToModel(client, clientEntity);
            client.setClientId(clientEntity.getName());
            this.addScopes(realm, (ClientModel)client, (ClientEntity)clientEntity);
        }
        logger.info((Object)("OAuth clients imported: " + clients));
    }

    protected ApplicationModel findApplicationById(KeycloakSession keycloakSession, String applicationId) {
        for (RealmModel realm : keycloakSession.getRealms()) {
            ApplicationModel appModel = realm.getApplicationById(applicationId);
            if (appModel == null) continue;
            return appModel;
        }
        return null;
    }

    public void importUsers(KeycloakSession keycloakSession, String fileName) {
        List<UserEntity> users = this.importReader.readEntities(fileName, UserEntity.class);
        for (UserEntity userEntity : users) {
            List credentials;
            List requiredActions;
            List socialLinks;
            RealmModel realm = keycloakSession.getRealm(userEntity.getRealmId());
            UserModel user = realm.addUser(userEntity.getId(), userEntity.getLoginName());
            for (RoleModel role : user.getRoleMappings()) {
                user.deleteRoleMapping(role);
            }
            this.propertiesManager.setBasicPropertiesToModel(user, userEntity);
            AuthenticationLinkEntity authLinkEntity = userEntity.getAuthenticationLink();
            if (authLinkEntity != null) {
                AuthenticationLinkModel authLinkModel = new AuthenticationLinkModel();
                this.propertiesManager.setBasicPropertiesToModel(authLinkModel, authLinkEntity);
                user.setAuthenticationLink(authLinkModel);
            }
            if ((socialLinks = userEntity.getSocialLinks()) != null && !socialLinks.isEmpty()) {
                for (SocialLinkEntity socialLinkEntity : socialLinks) {
                    SocialLinkModel socialLinkModel = new SocialLinkModel();
                    this.propertiesManager.setBasicPropertiesToModel(socialLinkModel, socialLinkEntity);
                    realm.addSocialLink(user, socialLinkModel);
                }
            }
            if ((requiredActions = userEntity.getRequiredActions()) != null && !requiredActions.isEmpty()) {
                for (UserModel.RequiredAction requiredAction : requiredActions) {
                    user.addRequiredAction(requiredAction);
                }
            }
            if (userEntity.getAttributes() != null) {
                for (Map.Entry entry : userEntity.getAttributes().entrySet()) {
                    user.setAttribute((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if (userEntity.getRoleIds() != null) {
                for (String string : userEntity.getRoleIds()) {
                    RoleModel role = realm.getRoleById(string);
                    user.grantRole(role);
                }
            }
            if ((credentials = userEntity.getCredentials()) == null) continue;
            for (CredentialEntity credEntity : credentials) {
                UserCredentialValueModel credModel = new UserCredentialValueModel();
                this.propertiesManager.setBasicPropertiesToModel(credModel, credEntity);
                user.updateCredentialDirectly(credModel);
            }
        }
        logger.infof("%d users imported: ", (Object)users.size());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Imported users: " + users));
        }
    }

    public void importUserFailures(KeycloakSession keycloakSession, String fileName) {
        List<UsernameLoginFailureEntity> userFailures = this.importReader.readEntities(fileName, UsernameLoginFailureEntity.class);
        for (UsernameLoginFailureEntity entity : userFailures) {
            RealmModel realm = keycloakSession.getRealm(entity.getRealmId());
            UsernameLoginFailureModel model = realm.addUserLoginFailure(entity.getUsername());
            this.propertiesManager.setBasicPropertiesToModel(model, entity);
            for (int i = 0; i < entity.getNumFailures(); ++i) {
                model.incrementFailures();
            }
        }
    }
}

