/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.exportimport.io.zip;

import de.idyl.winzipaes.AesZipFileDecrypter;
import de.idyl.winzipaes.impl.AESDecrypter;
import de.idyl.winzipaes.impl.AESDecrypterBC;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import org.codehaus.jackson.map.ObjectMapper;
import org.keycloak.exportimport.io.ImportReader;
import org.keycloak.util.JsonSerialization;

public class EncryptedZIPImportReader
implements ImportReader {
    private final File zipFile;
    private final ObjectMapper objectMapper;
    private final String password;
    private final AesZipFileDecrypter decrypter;

    public EncryptedZIPImportReader(String zipFileName, String password) {
        try {
            this.zipFile = new File(zipFileName);
            if (!this.zipFile.exists()) {
                throw new IllegalStateException("File " + zipFileName + " doesn't exists");
            }
            this.objectMapper = JsonSerialization.mapper;
            AESDecrypterBC decrypter = new AESDecrypterBC();
            this.decrypter = new AesZipFileDecrypter(this.zipFile, (AESDecrypter)decrypter);
            this.password = password;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public <T> List<T> readEntities(String fileName, Class<T> entityClass) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            this.decrypter.extractEntry(this.decrypter.getEntry(fileName), (OutputStream)bos, this.password);
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            Object[] template = (Object[])Array.newInstance(entityClass, 0);
            Object[] result = (Object[])this.objectMapper.readValue((InputStream)bis, template.getClass());
            return Arrays.asList(result);
        }
        catch (Exception ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public void closeImportReader() {
        try {
            this.decrypter.close();
        }
        catch (Exception ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

