/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal;

import java.io.Serializable;
import java.util.List;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.IdGenerator;
import org.picketlink.idm.PermissionManager;
import org.picketlink.idm.event.EventBridge;
import org.picketlink.idm.internal.AbstractIdentityContext;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.permission.Permission;
import org.picketlink.idm.permission.acl.spi.PermissionHandlerPolicy;
import org.picketlink.idm.spi.IdentityContext;
import org.picketlink.idm.spi.StoreSelector;

public class ContextualPermissionManager
extends AbstractIdentityContext
implements PermissionManager {
    private final StoreSelector storeSelector;

    public ContextualPermissionManager(Partition partition, EventBridge eventBridge, IdGenerator idGenerator, PermissionHandlerPolicy permissionHandlerPolicy, StoreSelector storeSelector) {
        super(partition, eventBridge, idGenerator, permissionHandlerPolicy);
        this.storeSelector = storeSelector;
    }

    public List<Permission> listPermissions(Object resource) {
        return this.storeSelector.getStoreForPermissionOperation((IdentityContext)this).listPermissions((IdentityContext)this, resource);
    }

    public List<Permission> listPermissions(Class<?> resourceClass, Serializable identifier) {
        return this.storeSelector.getStoreForPermissionOperation((IdentityContext)this).listPermissions((IdentityContext)this, resourceClass, identifier);
    }

    public List<Permission> listPermissions(Class<?> resourceClass, Serializable identifier, String operation) {
        return this.storeSelector.getStoreForPermissionOperation((IdentityContext)this).listPermissions((IdentityContext)this, resourceClass, identifier, operation);
    }

    public List<Permission> listPermissions(Object resource, String operation) {
        return this.storeSelector.getStoreForPermissionOperation((IdentityContext)this).listPermissions((IdentityContext)this, resource, operation);
    }

    public void grantPermission(IdentityType assignee, Object resource, String operation) {
        try {
            this.storeSelector.getStoreForPermissionOperation((IdentityContext)this).grantPermission((IdentityContext)this, assignee, resource, operation);
        }
        catch (Exception e) {
            throw IDMMessages.MESSAGES.permissionGrantFailed(assignee, resource, operation, (Throwable)e);
        }
    }

    public void revokePermission(IdentityType assignee, Object resource, String operation) {
        try {
            this.storeSelector.getStoreForPermissionOperation((IdentityContext)this).revokePermission((IdentityContext)this, assignee, resource, operation);
        }
        catch (Exception ex) {
            throw IDMMessages.MESSAGES.permissionRevokeFailed(assignee, resource, operation, (Throwable)ex);
        }
    }

    public void clearPermissions(Object resource) {
        try {
            this.storeSelector.getStoreForPermissionOperation((IdentityContext)this).revokeAllPermissions((IdentityContext)this, resource);
        }
        catch (Exception ex) {
            throw IDMMessages.MESSAGES.permissionRevokeAllFailed(resource, (Throwable)ex);
        }
    }

    public List<String> listOperations(Class<?> resourceClass) {
        return null;
    }
}

