/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.jackson.map.ObjectMapper;
import org.keycloak.social.AuthCallback;
import org.keycloak.social.AuthRequest;
import org.keycloak.social.SocialAccessDeniedException;
import org.keycloak.social.SocialProvider;
import org.keycloak.social.SocialProviderConfig;
import org.keycloak.social.SocialProviderException;
import org.keycloak.social.SocialUser;
import org.keycloak.social.utils.SimpleHttp;

public abstract class AbstractOAuth2Provider
implements SocialProvider {
    private static ObjectMapper mapper = new ObjectMapper();
    private static final String AUTHORIZATION_CODE = "authorization_code";
    private static final String ACCESS_TOKEN = "access_token";
    private static final String CLIENT_ID = "client_id";
    private static final String CLIENT_SECRET = "client_secret";
    private static final String CODE = "code";
    private static final String GRANT_TYPE = "grant_type";
    private static final String REDIRECT_URI = "redirect_uri";
    private static final String RESPONSE_TYPE = "response_type";
    private static final String SCOPE = "scope";
    private static final String STATE = "state";
    private static final String TOKEN_REGEX = "access_token=([^&]+)";

    @Override
    public abstract String getId();

    @Override
    public abstract String getName();

    protected abstract String getScope();

    protected abstract String getAuthUrl();

    protected abstract String getTokenUrl();

    protected abstract SocialUser getProfile(String var1) throws SocialProviderException;

    @Override
    public AuthRequest getAuthUrl(SocialProviderConfig config, String state) throws SocialProviderException {
        return AuthRequest.create(this.getAuthUrl()).setQueryParam(CLIENT_ID, config.getKey()).setQueryParam(RESPONSE_TYPE, CODE).setQueryParam(SCOPE, this.getScope()).setQueryParam(REDIRECT_URI, config.getCallbackUrl()).setQueryParam(STATE, state).build();
    }

    @Override
    public SocialUser processCallback(SocialProviderConfig config, AuthCallback callback) throws SocialProviderException {
        String error = callback.getQueryParam("error");
        if (error != null) {
            if (error.equals("access_denied")) {
                throw new SocialAccessDeniedException();
            }
            throw new SocialProviderException(error);
        }
        try {
            String accessToken;
            String code = callback.getQueryParam(CODE);
            String response = SimpleHttp.doPost(this.getTokenUrl()).param(CODE, code).param(CLIENT_ID, config.getKey()).param(CLIENT_SECRET, config.getSecret()).param(REDIRECT_URI, config.getCallbackUrl()).param(GRANT_TYPE, AUTHORIZATION_CODE).asString();
            if (response.startsWith("{")) {
                accessToken = mapper.readTree(response).get(ACCESS_TOKEN).getTextValue();
            } else {
                Matcher matcher = Pattern.compile(TOKEN_REGEX).matcher(response);
                if (matcher.find()) {
                    accessToken = matcher.group(1);
                } else {
                    throw new SocialProviderException("Invalid response, could not find token");
                }
            }
            return this.getProfile(accessToken);
        }
        catch (IOException e) {
            throw new SocialProviderException(e);
        }
    }
}

