/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.provider.ProviderSession;
import org.keycloak.services.DefaultProviderSessionFactory;

public class DefaultProviderSession
implements ProviderSession {
    private DefaultProviderSessionFactory factory;
    private Map<Integer, Provider> providers = new HashMap<Integer, Provider>();

    public DefaultProviderSession(DefaultProviderSessionFactory factory) {
        this.factory = factory;
    }

    public <T extends Provider> T getProvider(Class<T> clazz) {
        ProviderFactory<T> providerFactory;
        Integer hash = clazz.hashCode();
        Provider provider = this.providers.get(hash);
        if (provider == null && (providerFactory = this.factory.getProviderFactory(clazz)) != null) {
            provider = providerFactory.create((ProviderSession)this);
            this.providers.put(hash, provider);
        }
        return (T)provider;
    }

    public <T extends Provider> T getProvider(Class<T> clazz, String id) {
        ProviderFactory<T> providerFactory;
        Integer hash = clazz.hashCode() + id.hashCode();
        Provider provider = this.providers.get(hash);
        if (provider == null && (providerFactory = this.factory.getProviderFactory(clazz, id)) != null) {
            provider = providerFactory.create((ProviderSession)this);
            this.providers.put(hash, provider);
        }
        return (T)provider;
    }

    public <T extends Provider> Set<String> listProviderIds(Class<T> clazz) {
        return this.factory.getAllProviderIds(clazz);
    }

    public <T extends Provider> Set<T> getAllProviders(Class<T> clazz) {
        HashSet<T> providers = new HashSet<T>();
        for (String id : this.listProviderIds(clazz)) {
            providers.add(this.getProvider(clazz, id));
        }
        return providers;
    }

    public void close() {
        for (Provider p : this.providers.values()) {
            p.close();
        }
    }
}

