/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.validation;

import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.keycloak.models.PasswordPolicy;

public class Validation {
    public static String validateRegistrationForm(MultivaluedMap<String, String> formData, List<String> requiredCredentialTypes) {
        if (Validation.isEmpty((String)formData.getFirst((Object)"firstName"))) {
            return "missingFirstName";
        }
        if (Validation.isEmpty((String)formData.getFirst((Object)"lastName"))) {
            return "missingLastName";
        }
        if (Validation.isEmpty((String)formData.getFirst((Object)"email"))) {
            return "missingEmail";
        }
        if (Validation.isEmpty((String)formData.getFirst((Object)"username"))) {
            return "missingUsername";
        }
        if (requiredCredentialTypes.contains("password")) {
            if (Validation.isEmpty((String)formData.getFirst((Object)"password"))) {
                return "missingPassword";
            }
            if (!((String)formData.getFirst((Object)"password")).equals(formData.getFirst((Object)"password-confirm"))) {
                return "invalidPasswordConfirm";
            }
        }
        return null;
    }

    public static String validatePassword(MultivaluedMap<String, String> formData, PasswordPolicy policy) {
        return policy.validate((String)formData.getFirst((Object)"password"));
    }

    public static String validateUpdateProfileForm(MultivaluedMap<String, String> formData) {
        if (Validation.isEmpty((String)formData.getFirst((Object)"firstName"))) {
            return "missingFirstName";
        }
        if (Validation.isEmpty((String)formData.getFirst((Object)"lastName"))) {
            return "missingLastName";
        }
        if (Validation.isEmpty((String)formData.getFirst((Object)"email"))) {
            return "missingEmail";
        }
        return null;
    }

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }
}

