/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.client.util;

import java.net.URI;
import org.apache.http.client.methods.RequestBuilder;
import org.keycloak.authorization.client.Configuration;
import org.keycloak.authorization.client.representation.ServerConfiguration;
import org.keycloak.authorization.client.util.HttpMethod;

public class Http {
    private final Configuration configuration;
    private ServerConfiguration serverConfiguration;

    public Http(Configuration configuration) {
        this.configuration = configuration;
    }

    public <R> HttpMethod<R> get(String path) {
        return this.method(RequestBuilder.get((String)(this.serverConfiguration.getIssuer() + path)));
    }

    public <R> HttpMethod<R> get(URI path) {
        return this.method(RequestBuilder.get((URI)path));
    }

    public <R> HttpMethod<R> post(URI path) {
        return this.method(RequestBuilder.post((URI)path));
    }

    public <R> HttpMethod<R> post(String path) {
        return this.method(RequestBuilder.post((String)(this.serverConfiguration.getIssuer() + path)));
    }

    public <R> HttpMethod<R> delete(String path) {
        return this.method(RequestBuilder.delete((String)(this.serverConfiguration.getIssuer() + path)));
    }

    private <R> HttpMethod<R> method(RequestBuilder builder) {
        return new HttpMethod(this.configuration, builder);
    }

    public void setServerConfiguration(ServerConfiguration serverConfiguration) {
        this.serverConfiguration = serverConfiguration;
    }
}

