/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.adapter.extension;

import io.undertow.io.IoCallback;
import io.undertow.io.Sender;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceChangeListener;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.util.ETag;
import io.undertow.util.MimeMappings;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.server.mgmt.domain.ExtensibleHttpManagement;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.keycloak.subsystem.adapter.extension.AbstractAdapterConfigurationAddHandler;
import org.keycloak.subsystem.adapter.extension.AbstractAdapterConfigurationDefinition;
import org.keycloak.subsystem.adapter.extension.AbstractAdapterConfigurationRemoveHandler;
import org.keycloak.subsystem.adapter.extension.AbstractAdapterConfigurationWriteAttributeHandler;
import org.keycloak.subsystem.adapter.extension.KeycloakAdapterConfigService;
import org.keycloak.subsystem.adapter.extension.KeycloakHttpAuthenticationFactoryService;
import org.wildfly.security.http.HttpServerAuthenticationMechanismFactory;

final class SecureServerDefinition
extends AbstractAdapterConfigurationDefinition {
    public static final String TAG_NAME = "secure-server";

    SecureServerDefinition() {
        super(TAG_NAME, ALL_ATTRIBUTES, new SecureServerAddHandler(), new SecureServerRemoveHandler(), new SecureServerWriteHandler());
    }

    private static Service<Void> createHttpManagementConfigContextService(final String factoryName, final InjectedValue<ExtensibleHttpManagement> httpConfigContext) {
        final String contextName = "/keycloak/adapter/" + factoryName + "/";
        return new Service<Void>(){

            public void start(StartContext startContext) throws StartException {
                ExtensibleHttpManagement extensibleHttpManagement = (ExtensibleHttpManagement)httpConfigContext.getValue();
                extensibleHttpManagement.addStaticContext(contextName, new ResourceManager(){

                    public Resource getResource(String path) throws IOException {
                        KeycloakAdapterConfigService adapterConfigService = KeycloakAdapterConfigService.getInstance();
                        final String config = adapterConfigService.getJSON(factoryName);
                        if (config == null) {
                            return null;
                        }
                        return new Resource(){

                            public String getPath() {
                                return null;
                            }

                            public Date getLastModified() {
                                return null;
                            }

                            public String getLastModifiedString() {
                                return null;
                            }

                            public ETag getETag() {
                                return null;
                            }

                            public String getName() {
                                return null;
                            }

                            public boolean isDirectory() {
                                return false;
                            }

                            public List<Resource> list() {
                                return Collections.emptyList();
                            }

                            public String getContentType(MimeMappings mimeMappings) {
                                return "application/json";
                            }

                            public void serve(Sender sender, HttpServerExchange exchange, IoCallback completionCallback) {
                                sender.send(config);
                            }

                            public Long getContentLength() {
                                return config.length();
                            }

                            public String getCacheKey() {
                                return null;
                            }

                            public File getFile() {
                                return null;
                            }

                            public Path getFilePath() {
                                return null;
                            }

                            public File getResourceManagerRoot() {
                                return null;
                            }

                            public Path getResourceManagerRootPath() {
                                return null;
                            }

                            public URL getUrl() {
                                return null;
                            }
                        };
                    }

                    public boolean isResourceChangeListenerSupported() {
                        return false;
                    }

                    public void registerResourceChangeListener(ResourceChangeListener listener) {
                    }

                    public void removeResourceChangeListener(ResourceChangeListener listener) {
                    }

                    public void close() throws IOException {
                    }
                });
            }

            public void stop(StopContext stopContext) {
                ((ExtensibleHttpManagement)httpConfigContext.getValue()).removeContext(contextName);
            }

            public Void getValue() throws IllegalStateException, IllegalArgumentException {
                return null;
            }
        };
    }

    static final class SecureServerWriteHandler
    extends AbstractAdapterConfigurationWriteAttributeHandler {
        SecureServerWriteHandler() {
            super(AbstractAdapterConfigurationDefinition.ALL_ATTRIBUTES);
        }
    }

    static final class SecureServerRemoveHandler
    extends AbstractAdapterConfigurationRemoveHandler {
        SecureServerRemoveHandler() {
        }

        @Override
        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            super.performRuntime(context, operation, model);
            PathAddress pathAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
            String factoryName = pathAddress.getLastElement().getValue();
            ServiceName serviceName = context.getCapabilityServiceName("org.wildfly.security.http-server-mechanism-factory", factoryName, HttpServerAuthenticationMechanismFactory.class);
            context.removeService(serviceName);
        }

        protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            super.recoverServices(context, operation, model);
            SecureServerAddHandler.installCapability(context, operation);
        }
    }

    static final class SecureServerAddHandler
    extends AbstractAdapterConfigurationAddHandler {
        static final String HTTP_SERVER_AUTHENTICATION_CAPABILITY = "org.wildfly.security.http-server-mechanism-factory";
        static final String HTTP_MANAGEMENT_HTTP_EXTENSIBLE_CAPABILITY = "org.wildfly.management.http.extensible";
        static RuntimeCapability<Void> HTTP_SERVER_AUTHENTICATION_RUNTIME_CAPABILITY;

        SecureServerAddHandler() {
            super(HTTP_SERVER_AUTHENTICATION_RUNTIME_CAPABILITY, AbstractAdapterConfigurationDefinition.ALL_ATTRIBUTES);
        }

        @Override
        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            super.performRuntime(context, operation, model);
            if (HTTP_SERVER_AUTHENTICATION_RUNTIME_CAPABILITY != null) {
                SecureServerAddHandler.installCapability(context, operation);
            }
        }

        static void installCapability(OperationContext context, ModelNode operation) throws OperationFailedException {
            PathAddress pathAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
            String factoryName = pathAddress.getLastElement().getValue();
            ServiceName serviceName = context.getCapabilityServiceName(HTTP_SERVER_AUTHENTICATION_CAPABILITY, factoryName, HttpServerAuthenticationMechanismFactory.class);
            boolean publicClient = PUBLIC_CLIENT.resolveModelAttribute(context, operation).asBoolean(false);
            if (!publicClient) {
                throw new OperationFailedException("Only public clients are allowed to have their configuration exposed through the management interface");
            }
            KeycloakHttpAuthenticationFactoryService service = new KeycloakHttpAuthenticationFactoryService(factoryName);
            ServiceTarget serviceTarget = context.getServiceTarget();
            InjectedValue injectedValue = new InjectedValue();
            serviceTarget.addService(serviceName.append(new String[]{"http-management-context"}), SecureServerDefinition.createHttpManagementConfigContextService(factoryName, (InjectedValue<ExtensibleHttpManagement>)injectedValue)).addDependency(context.getCapabilityServiceName(HTTP_MANAGEMENT_HTTP_EXTENSIBLE_CAPABILITY, ExtensibleHttpManagement.class), ExtensibleHttpManagement.class, (Injector)injectedValue).setInitialMode(ServiceController.Mode.ACTIVE).install();
            serviceTarget.addService(serviceName, (Service)service).setInitialMode(ServiceController.Mode.ACTIVE).install();
        }

        static {
            try {
                HTTP_SERVER_AUTHENTICATION_RUNTIME_CAPABILITY = RuntimeCapability.Builder.of((String)HTTP_SERVER_AUTHENTICATION_CAPABILITY, (boolean)true, HttpServerAuthenticationMechanismFactory.class).build();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
    }
}

