/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.common;

import java.util.HashSet;
import java.util.Set;
import org.drools.core.util.KeyStoreHelper;
import org.kie.server.api.model.KieServerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreHelperUtil {
    private static final String PROP_PWD_SERVER_ALIAS = "kie.keystore.key.server.alias";
    private static final String PROP_PWD_SERVER_PWD = "kie.keystore.key.server.pwd";
    private static final String PROP_PWD_CTRL_ALIAS = "kie.keystore.key.ctrl.alias";
    private static final String PROP_PWD_CTRL_PWD = "kie.keystore.key.ctrl.pwd";
    private static final Logger logger = LoggerFactory.getLogger(KeyStoreHelperUtil.class);
    private static Set<String> invocationCache = new HashSet<String>();

    public static String loadServerPassword() {
        String defaultPassword = System.getProperty("org.kie.server.pwd", "kieserver1!");
        return KeyStoreHelperUtil.loadPasswordKey(PROP_PWD_SERVER_ALIAS, PROP_PWD_SERVER_PWD, defaultPassword);
    }

    public static String loadControllerPassword(KieServerConfig config) {
        return KeyStoreHelperUtil.loadControllerPassword(config.getConfigItemValue("org.kie.server.controller.pwd", "kieserver1!"));
    }

    public static String loadControllerPassword(String defaultPassword) {
        return KeyStoreHelperUtil.loadPasswordKey(PROP_PWD_CTRL_ALIAS, PROP_PWD_CTRL_PWD, defaultPassword);
    }

    public static String loadPasswordKey(String pwdKeyAliasProperty, String pwdKeyPasswordProperty, String defaultPassword) {
        String passwordKey;
        block2: {
            KeyStoreHelper keyStoreHelper = new KeyStoreHelper();
            try {
                String pwdKeyAlias = System.getProperty(pwdKeyAliasProperty, "");
                String pwdKeyPassword = System.getProperty(pwdKeyPasswordProperty, "");
                passwordKey = keyStoreHelper.getPasswordKey(pwdKeyAlias, pwdKeyPassword.toCharArray());
            }
            catch (RuntimeException re) {
                passwordKey = defaultPassword;
                if (!KeyStoreHelperUtil.hasNotBeenInvoked(pwdKeyAliasProperty, pwdKeyPasswordProperty, passwordKey)) break block2;
                logger.warn("Unable to load key store. Using password from configuration");
            }
        }
        return passwordKey;
    }

    private static boolean hasNotBeenInvoked(String pwdKeyAliasProperty, String pwdKeyPasswordProperty, String passwordKey) {
        if (invocationCache.contains(pwdKeyAliasProperty)) {
            return false;
        }
        invocationCache.add(pwdKeyAliasProperty);
        return true;
    }
}

