/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.websocket.common.config;

import java.util.Arrays;
import java.util.List;
import javax.websocket.Decoder;
import javax.websocket.Encoder;
import org.kie.server.controller.websocket.common.config.WebSocketClientConfigurationImpl;

public interface WebSocketClientConfiguration {
    public static Builder builder() {
        return new Builder();
    }

    public String getControllerUrl();

    public String getUserName();

    public String getPassword();

    public String getToken();

    public Long getMaxSessionIdleTimeout();

    public Long getAsyncSendTimeout();

    public List<Class<? extends Encoder>> getEncoders();

    public List<Class<? extends Decoder>> getDecoders();

    public static class Builder {
        private WebSocketClientConfigurationImpl config = new WebSocketClientConfigurationImpl();

        public Builder controllerUrl(String controllerUrl) {
            this.config.setControllerUrl(controllerUrl);
            return this;
        }

        public Builder userName(String userName) {
            this.config.setUserName(userName);
            return this;
        }

        public Builder token(String token) {
            this.config.setToken(token);
            return this;
        }

        public Builder password(String password) {
            this.config.setPassword(password);
            return this;
        }

        public Builder setMaxSessionIdleTimeout(Long maxSessionIdleTimeout) {
            this.config.setMaxSessionIdleTimeout(maxSessionIdleTimeout);
            return this;
        }

        public Builder setAsyncSendTimeout(Long asyncSendTimeout) {
            this.config.setAsyncSendTimeout(asyncSendTimeout);
            return this;
        }

        public Builder encoders(Class<? extends Encoder> ... encoders) {
            this.config.setEncoders(Arrays.asList(encoders));
            return this;
        }

        public Builder decoders(Class<? extends Decoder> ... decoders) {
            this.config.setDecoders(Arrays.asList(decoders));
            return this;
        }

        public WebSocketClientConfiguration build() {
            return this.config;
        }
    }
}

