/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.prometheus;

import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Summary;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.jbpm.workflow.instance.node.WorkItemNodeInstance;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.process.SLAViolatedEvent;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.server.services.prometheus.PrometheusMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusProcessEventListener
extends DefaultProcessEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrometheusProcessEventListener.class);
    protected static final Counter numberOfProcessInstancesStarted = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("kie_server_process_instance_started_total")).help("Kie Server Started Process Instances")).labelNames(new String[]{"container_id", "process_id"})).register();
    protected static final Counter numberOfSLAsViolated = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("kie_server_process_instance_sla_violated_total")).help("Kie Server Process Instances SLA Violated")).labelNames(new String[]{"container_id", "process_id", "node_name"})).register();
    protected static final Counter numberOfProcessInstancesCompleted = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("kie_server_process_instance_completed_total")).help("Kie Server Completed Process Instances")).labelNames(new String[]{"container_id", "process_id", "status"})).register();
    protected static final Gauge runningProcessInstances = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("kie_server_process_instance_running_total")).help("Kie Server Running Process Instances")).labelNames(new String[]{"container_id", "process_id"})).register();
    protected static final Summary processInstancesDuration = (Summary)((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.build().name("kie_server_process_instance_duration_seconds")).help("Kie Server Process Instances Duration")).labelNames(new String[]{"container_id", "process_id"})).register();
    protected static final Summary workItemsDuration = (Summary)((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.build().name("kie_server_work_item_duration_seconds")).help("Kie Server Work Items Duration")).labelNames(new String[]{"name"})).register();

    protected static void recordRunningProcessInstance(String containerId, String processId) {
        ((Gauge.Child)runningProcessInstances.labels(new String[]{containerId, processId})).inc();
    }

    public void afterProcessStarted(ProcessStartedEvent event) {
        LOGGER.debug("After process started event: {}", (Object)event);
        WorkflowProcessInstanceImpl processInstance = (WorkflowProcessInstanceImpl)event.getProcessInstance();
        ((Counter.Child)numberOfProcessInstancesStarted.labels(new String[]{processInstance.getDeploymentId(), processInstance.getProcessId()})).inc();
        PrometheusProcessEventListener.recordRunningProcessInstance(processInstance.getDeploymentId(), processInstance.getProcessId());
    }

    public void afterProcessCompleted(ProcessCompletedEvent event) {
        LOGGER.debug("After process completed event: {}", (Object)event);
        WorkflowProcessInstanceImpl processInstance = (WorkflowProcessInstanceImpl)event.getProcessInstance();
        ((Gauge.Child)runningProcessInstances.labels(new String[]{processInstance.getDeploymentId(), processInstance.getProcessId()})).dec();
        ((Counter.Child)numberOfProcessInstancesCompleted.labels(new String[]{processInstance.getDeploymentId(), processInstance.getProcessId(), String.valueOf(processInstance.getState())})).inc();
        if (processInstance.getStartDate() != null) {
            double duration = PrometheusMetrics.millisToSeconds(System.currentTimeMillis() - processInstance.getStartDate().getTime());
            ((Summary.Child)processInstancesDuration.labels(new String[]{processInstance.getDeploymentId(), processInstance.getProcessId()})).observe(duration);
            LOGGER.debug("Process Instance duration: {}s", (Object)duration);
        }
    }

    public void beforeNodeLeft(ProcessNodeLeftEvent event) {
        WorkItemNodeInstance wi;
        LOGGER.debug("Before Node left event: {}", (Object)event);
        NodeInstance nodeInstance = event.getNodeInstance();
        if (nodeInstance instanceof WorkItemNodeInstance && (wi = (WorkItemNodeInstance)nodeInstance).getTriggerTime() != null) {
            String name = wi.getWorkItem().getName();
            double duration = PrometheusMetrics.millisToSeconds(System.currentTimeMillis() - wi.getTriggerTime().getTime());
            ((Summary.Child)workItemsDuration.labels(new String[]{name})).observe(duration);
            LOGGER.debug("Work Item {}, duration: {}s", (Object)name, (Object)duration);
        }
    }

    public void afterSLAViolated(SLAViolatedEvent event) {
        LOGGER.debug("After SLA violated event: {}", (Object)event);
        WorkflowProcessInstanceImpl processInstance = (WorkflowProcessInstanceImpl)event.getProcessInstance();
        if (processInstance != null && event.getNodeInstance() != null) {
            ((Counter.Child)numberOfSLAsViolated.labels(new String[]{processInstance.getDeploymentId(), processInstance.getProcessId(), event.getNodeInstance().getNodeName()})).inc();
        }
    }
}

