/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import org.apache.lucene.util.Bits;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;

final class SingletonSortedNumericDoubleValues
extends SortedNumericDoubleValues {
    private final NumericDoubleValues in;
    private final Bits docsWithField;
    private double value;
    private int count;

    SingletonSortedNumericDoubleValues(NumericDoubleValues in, Bits docsWithField) {
        this.in = in;
        this.docsWithField = docsWithField instanceof Bits.MatchAllBits ? null : docsWithField;
    }

    public NumericDoubleValues getNumericDoubleValues() {
        return this.in;
    }

    public Bits getDocsWithField() {
        return this.docsWithField;
    }

    @Override
    public void setDocument(int doc) {
        this.value = this.in.get(doc);
        this.count = this.docsWithField != null && this.value == 0.0 && !this.docsWithField.get(doc) ? 0 : 1;
    }

    @Override
    public double valueAt(int index) {
        return this.value;
    }

    @Override
    public int count() {
        return this.count;
    }
}

