/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.repositories.git.hooks.impl;

import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.structure.backend.repositories.git.hooks.PostCommitNotificationService;
import org.guvnor.structure.backend.repositories.git.hooks.impl.MessageReader;
import org.guvnor.structure.repositories.impl.git.GitRepository;
import org.guvnor.structure.repositories.impl.git.event.NotificationType;
import org.guvnor.structure.repositories.impl.git.event.PostCommitNotificationEvent;
import org.uberfire.commons.services.cdi.Startup;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.spaces.SpacesAPI;

@ApplicationScoped
@Startup
public class PostCommitNotificationServiceImpl
implements PostCommitNotificationService {
    private SessionInfo sessionInfo;
    private Event<PostCommitNotificationEvent> notificationEvent;
    private MessageReader reader;

    PostCommitNotificationServiceImpl() {
    }

    @Inject
    public PostCommitNotificationServiceImpl(SessionInfo sessionInfo, Event<PostCommitNotificationEvent> notificationEvent, MessageReader reader) {
        this.sessionInfo = sessionInfo;
        this.notificationEvent = notificationEvent;
        this.reader = reader;
    }

    @PostConstruct
    public void init() {
        this.reader.init(System.getProperty("appformer.git.hooks.bundle"));
    }

    @Override
    public void notifyUser(GitRepository repo, Integer exitCode) {
        Optional<String> optional;
        if (this.sessionInfo != null && !SpacesAPI.DEFAULT_SPACE.equals((Object)repo.getSpace()) && (optional = this.reader.resolveMessage(exitCode)).isPresent()) {
            this.notificationEvent.fire((Object)new PostCommitNotificationEvent(NotificationType.fromExitCode((int)exitCode), optional.get()));
        }
    }
}

