/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.builder;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ejb.Asynchronous;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.common.services.builder.AsyncIncrementalBuilder;
import org.guvnor.common.services.project.builder.model.BuildResults;
import org.guvnor.common.services.project.builder.model.IncrementalBuildResults;
import org.guvnor.common.services.project.builder.service.BuildService;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.service.ModuleService;
import org.uberfire.commons.async.DescriptiveRunnable;
import org.uberfire.commons.concurrent.Managed;

@Singleton
@Startup
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class IncrementalBuilderExecutorManager {
    @Inject
    private ModuleService<? extends Module> moduleService;
    private BuildService buildService;
    private Event<BuildResults> buildResultsEvent;
    private Event<IncrementalBuildResults> incrementalBuildResultsEvent;
    private ExecutorService executorService;
    private AtomicBoolean useExecService = new AtomicBoolean(false);

    public IncrementalBuilderExecutorManager() {
    }

    @Inject
    public IncrementalBuilderExecutorManager(ModuleService<? extends Module> moduleService, BuildService buildService, Event<BuildResults> buildResultsEvent, Event<IncrementalBuildResults> incrementalBuildResultsEvent, @Managed ExecutorService executorService) {
        this.moduleService = moduleService;
        this.buildService = buildService;
        this.buildResultsEvent = buildResultsEvent;
        this.incrementalBuildResultsEvent = incrementalBuildResultsEvent;
        this.executorService = executorService;
    }

    @Asynchronous
    public void execute(final AsyncIncrementalBuilder incrementalBuilder) {
        if (this.useExecService.get()) {
            this.getExecutorService().execute((Runnable)new DescriptiveRunnable(){

                public void run() {
                    incrementalBuilder.execute(IncrementalBuilderExecutorManager.this.moduleService, IncrementalBuilderExecutorManager.this.buildService, (Event<IncrementalBuildResults>)IncrementalBuilderExecutorManager.this.incrementalBuildResultsEvent, (Event<BuildResults>)IncrementalBuilderExecutorManager.this.buildResultsEvent);
                }

                public String getDescription() {
                    return incrementalBuilder.getDescription();
                }
            });
        } else {
            incrementalBuilder.execute(this.moduleService, this.buildService, this.incrementalBuildResultsEvent, this.buildResultsEvent);
        }
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        this.useExecService.set(true);
    }

    private ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setServices(ModuleService moduleService, BuildService buildService, Event<BuildResults> buildResultsEvent, Event<IncrementalBuildResults> incrementalBuildResultsEvent) {
        this.moduleService = moduleService;
        this.buildService = buildService;
        this.buildResultsEvent = buildResultsEvent;
        this.incrementalBuildResultsEvent = incrementalBuildResultsEvent;
        this.useExecService.set(true);
    }

    public void shutdown() {
        if (this.useExecService.get() && this.executorService != null) {
            this.executorService.shutdown();
            try {
                if (!this.executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                    this.executorService.shutdownNow();
                    if (!this.executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                        System.err.println("Pool did not terminate");
                    }
                }
            }
            catch (InterruptedException ie) {
                this.executorService.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }
}

