/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.contributors;

import java.util.Comparator;
import java.util.Objects;
import org.guvnor.structure.contributors.ContributorType;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;

@Portable
public class Contributor {
    private String username;
    private ContributorType type;
    public static final Comparator<Contributor> COMPARATOR = (o1, o2) -> {
        if (o1.getType().equals((Object)o2.getType())) {
            return o1.getUsername().toUpperCase().compareTo(o2.getUsername().toUpperCase());
        }
        if (ContributorType.PRIORITY_ORDER.indexOf((Object)o1.getType()) < ContributorType.PRIORITY_ORDER.indexOf((Object)o2.getType())) {
            return -1;
        }
        return 1;
    };

    public Contributor() {
    }

    public Contributor(@MapsTo(value="username") String username, @MapsTo(value="type") ContributorType type) {
        this.username = username;
        this.type = type;
    }

    public String getUsername() {
        return this.username;
    }

    public ContributorType getType() {
        return this.type;
    }

    public void setType(ContributorType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Contributor)) {
            return false;
        }
        Contributor that = (Contributor)o;
        return Objects.equals(this.username, that.username) && this.type == that.type;
    }

    public int hashCode() {
        int result = this.username != null ? this.username.hashCode() : 0;
        result = ~(~result);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = ~(~result);
        return result;
    }
}

