/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.nqueens.persistence;

import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.optaplanner.examples.common.app.CommonApp;
import org.optaplanner.examples.common.app.LoggingMain;
import org.optaplanner.examples.common.persistence.AbstractSolutionImporter;
import org.optaplanner.examples.nqueens.domain.Column;
import org.optaplanner.examples.nqueens.domain.NQueens;
import org.optaplanner.examples.nqueens.domain.Queen;
import org.optaplanner.examples.nqueens.domain.Row;
import org.optaplanner.persistence.common.api.domain.solution.SolutionFileIO;
import org.optaplanner.persistence.xstream.impl.domain.solution.XStreamSolutionFileIO;

public class NQueensGenerator
extends LoggingMain {
    protected final SolutionFileIO<NQueens> solutionFileIO;
    protected final File outputDir;

    public static void main(String[] args) {
        NQueensGenerator generator = new NQueensGenerator();
        generator.writeNQueens(4);
        generator.writeNQueens(8);
        generator.writeNQueens(16);
        generator.writeNQueens(32);
        generator.writeNQueens(64);
        generator.writeNQueens(256);
    }

    public NQueensGenerator() {
        this.solutionFileIO = new XStreamSolutionFileIO(new Class[]{NQueens.class});
        this.outputDir = new File(CommonApp.determineDataDir("nqueens"), "unsolved");
    }

    public NQueensGenerator(boolean withoutDao) {
        if (!withoutDao) {
            throw new IllegalArgumentException("The parameter withoutDao (" + withoutDao + ") must be true.");
        }
        this.solutionFileIO = null;
        this.outputDir = null;
    }

    private void writeNQueens(int n) {
        String outputFileName = n + "queens.xml";
        File outputFile = new File(this.outputDir, outputFileName);
        NQueens nQueens = this.createNQueens(n);
        this.solutionFileIO.write((Object)nQueens, outputFile);
        this.logger.info("Saved: {}", (Object)outputFile);
    }

    public NQueens createNQueens(int n) {
        NQueens nQueens = new NQueens();
        nQueens.setId(0L);
        nQueens.setN(n);
        nQueens.setColumnList(this.createColumnList(nQueens));
        nQueens.setRowList(this.createRowList(nQueens));
        nQueens.setQueenList(this.createQueenList(nQueens));
        BigInteger possibleSolutionSize = BigInteger.valueOf(nQueens.getN()).pow(nQueens.getN());
        this.logger.info("NQueens {} has {} queens with a search space of {}.", new Object[]{n, nQueens.getN(), AbstractSolutionImporter.getFlooredPossibleSolutionSize(possibleSolutionSize)});
        return nQueens;
    }

    private List<Column> createColumnList(NQueens nQueens) {
        int n = nQueens.getN();
        ArrayList<Column> columnList = new ArrayList<Column>(n);
        for (int i = 0; i < n; ++i) {
            Column column = new Column();
            column.setId(Long.valueOf(i));
            column.setIndex(i);
            columnList.add(column);
        }
        return columnList;
    }

    private List<Row> createRowList(NQueens nQueens) {
        int n = nQueens.getN();
        ArrayList<Row> rowList = new ArrayList<Row>(n);
        for (int i = 0; i < n; ++i) {
            Row row = new Row();
            row.setId(Long.valueOf(i));
            row.setIndex(i);
            rowList.add(row);
        }
        return rowList;
    }

    private List<Queen> createQueenList(NQueens nQueens) {
        int n = nQueens.getN();
        ArrayList<Queen> queenList = new ArrayList<Queen>(n);
        long id = 0L;
        for (Column column : nQueens.getColumnList()) {
            Queen queen = new Queen();
            queen.setId(id);
            ++id;
            queen.setColumn(column);
            queenList.add(queen);
        }
        return queenList;
    }
}

