/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvelcompiler.context;

import java.util.Optional;
import org.drools.core.addon.TypeResolver;
import org.drools.mvelcompiler.MvelCompilerException;
import org.drools.mvelcompiler.context.ContextDeclarations;
import org.drools.mvelcompiler.context.Declaration;

public class MvelCompilerContext {
    private ContextDeclarations contextDeclarations = new ContextDeclarations();
    private final TypeResolver typeResolver;

    public MvelCompilerContext(TypeResolver typeResolver) {
        this.typeResolver = typeResolver;
    }

    public MvelCompilerContext addDeclaration(String name, Class<?> clazz) {
        this.contextDeclarations.addDeclarations(new Declaration(name, clazz));
        return this;
    }

    public MvelCompilerContext addCreatedDeclaration(String name, Class<?> clazz) {
        this.contextDeclarations.addDeclarations(new Declaration(name, clazz, true));
        return this;
    }

    public Optional<Declaration> findDeclarations(String name) {
        return this.contextDeclarations.findDeclaration(name);
    }

    public Optional<Class<?>> findEnum(String name) {
        try {
            return Optional.of(this.typeResolver.resolveType(name));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }

    public Class<?> resolveType(String name) {
        try {
            return this.typeResolver.resolveType(name);
        }
        catch (ClassNotFoundException e) {
            throw new MvelCompilerException(e);
        }
    }
}

