/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit.variable;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.jbpm.process.audit.VariableInstanceLog;
import org.jbpm.process.audit.event.AuditEventBuilder;
import org.jbpm.process.audit.variable.StringProcessVariableIndexer;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.kie.internal.process.ProcessVariableIndexer;

public class ProcessIndexerManager {
    private static ServiceLoader<ProcessVariableIndexer> processVariableIndexers = ServiceLoader.load(ProcessVariableIndexer.class);
    private static ProcessIndexerManager INSTANCE;
    private List<ProcessVariableIndexer> indexers = new ArrayList<ProcessVariableIndexer>();

    private ProcessIndexerManager() {
        for (ProcessVariableIndexer indexer : processVariableIndexers) {
            this.indexers.add(indexer);
        }
        this.indexers.add(new StringProcessVariableIndexer());
    }

    public List<org.kie.api.runtime.manager.audit.VariableInstanceLog> index(AuditEventBuilder builder, ProcessVariableChangedEvent event) {
        String variableName = event.getVariableId();
        Object variable = event.getNewValue();
        for (ProcessVariableIndexer indexer : this.indexers) {
            List indexed;
            if (!indexer.accept(variable) || (indexed = indexer.index(variableName, variable)) == null) continue;
            for (org.kie.api.runtime.manager.audit.VariableInstanceLog processVariable : indexed) {
                org.kie.api.runtime.manager.audit.VariableInstanceLog log = (org.kie.api.runtime.manager.audit.VariableInstanceLog)builder.buildEvent(event);
                ((VariableInstanceLog)processVariable).setProcessId(log.getProcessId());
                ((VariableInstanceLog)processVariable).setProcessInstanceId(log.getProcessInstanceId());
                ((VariableInstanceLog)processVariable).setDate(log.getDate());
                ((VariableInstanceLog)processVariable).setExternalId(log.getExternalId());
                ((VariableInstanceLog)processVariable).setOldValue(log.getOldValue());
                ((VariableInstanceLog)processVariable).setVariableInstanceId(log.getVariableInstanceId());
            }
            return indexed;
        }
        return null;
    }

    public static ProcessIndexerManager get() {
        if (INSTANCE == null) {
            INSTANCE = new ProcessIndexerManager();
        }
        return INSTANCE;
    }
}

