/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.generator.bean;

import com.sun.codemodel.JClassContainer;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JDocComment;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.generator.annotation.spec.XmlAccessorTypeWriter;
import com.sun.tools.xjc.generator.bean.ClassOutlineImpl;
import com.sun.tools.xjc.generator.bean.MethodWriter;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.outline.Aspect;
import com.sun.tools.xjc.outline.Outline;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlEnum;

@XmlEnum(value=Boolean.class)
public enum ImplStructureStrategy {
    BEAN_ONLY{

        @Override
        protected Result createClasses(Outline outline, CClassInfo bean) {
            JClassContainer parent = outline.getContainer(bean.parent(), Aspect.EXPOSED);
            JDefinedClass impl = outline.getClassFactory().createClass(parent, 1 | (parent.isPackage() ? 0 : 16) | (bean.isAbstract() ? 32 : 0), bean.shortName, bean.getLocator());
            impl.annotate2(XmlAccessorTypeWriter.class).value(XmlAccessType.FIELD);
            return new Result(impl, impl);
        }

        @Override
        protected JPackage getPackage(JPackage pkg, Aspect a) {
            return pkg;
        }

        @Override
        protected MethodWriter createMethodWriter(final ClassOutlineImpl target) {
            assert (target.ref == target.implClass);
            return new MethodWriter(target){
                private final JDefinedClass impl;
                private JMethod implMethod;
                {
                    super(x0);
                    this.impl = target.implClass;
                }

                @Override
                public JVar addParameter(JType type, String name) {
                    return this.implMethod.param(type, name);
                }

                @Override
                public JMethod declareMethod(JType returnType, String methodName) {
                    this.implMethod = this.impl.method(1, returnType, methodName);
                    return this.implMethod;
                }

                @Override
                public JDocComment javadoc() {
                    return this.implMethod.javadoc();
                }
            };
        }

        @Override
        protected void _extends(ClassOutlineImpl derived, ClassOutlineImpl base) {
            derived.implClass._extends(base.implRef);
        }
    }
    ,
    INTF_AND_IMPL{

        @Override
        protected Result createClasses(Outline outline, CClassInfo bean) {
            JClassContainer parent = outline.getContainer(bean.parent(), Aspect.EXPOSED);
            JDefinedClass intf = outline.getClassFactory().createInterface(parent, bean.shortName, bean.getLocator());
            parent = outline.getContainer(bean.parent(), Aspect.IMPLEMENTATION);
            JDefinedClass impl = outline.getClassFactory().createClass(parent, 1 | (parent.isPackage() ? 0 : 16) | (bean.isAbstract() ? 32 : 0), bean.shortName + "Impl", bean.getLocator());
            impl.annotate2(XmlAccessorTypeWriter.class).value(XmlAccessType.FIELD);
            impl._implements(intf);
            return new Result(intf, impl);
        }

        @Override
        protected JPackage getPackage(JPackage pkg, Aspect a) {
            switch (a) {
                case EXPOSED: {
                    return pkg;
                }
                case IMPLEMENTATION: {
                    return pkg.subPackage("impl");
                }
            }
            assert (false);
            throw new IllegalStateException();
        }

        @Override
        protected MethodWriter createMethodWriter(final ClassOutlineImpl target) {
            return new MethodWriter(target){
                private final JDefinedClass intf;
                private final JDefinedClass impl;
                private JMethod intfMethod;
                private JMethod implMethod;
                {
                    super(x0);
                    this.intf = target.ref;
                    this.impl = target.implClass;
                }

                @Override
                public JVar addParameter(JType type, String name) {
                    if (this.intf != null) {
                        this.intfMethod.param(type, name);
                    }
                    return this.implMethod.param(type, name);
                }

                @Override
                public JMethod declareMethod(JType returnType, String methodName) {
                    if (this.intf != null) {
                        this.intfMethod = this.intf.method(0, returnType, methodName);
                    }
                    this.implMethod = this.impl.method(1, returnType, methodName);
                    return this.implMethod;
                }

                @Override
                public JDocComment javadoc() {
                    if (this.intf != null) {
                        return this.intfMethod.javadoc();
                    }
                    return this.implMethod.javadoc();
                }
            };
        }

        @Override
        protected void _extends(ClassOutlineImpl derived, ClassOutlineImpl base) {
            derived.implClass._extends(base.implRef);
            derived.ref._implements(base.ref);
        }
    };


    protected abstract Result createClasses(Outline var1, CClassInfo var2);

    protected abstract JPackage getPackage(JPackage var1, Aspect var2);

    protected abstract MethodWriter createMethodWriter(ClassOutlineImpl var1);

    protected abstract void _extends(ClassOutlineImpl var1, ClassOutlineImpl var2);

    public static final class Result {
        public final JDefinedClass exposed;
        public final JDefinedClass implementation;

        public Result(JDefinedClass exposed, JDefinedClass implementation) {
            this.exposed = exposed;
            this.implementation = implementation;
        }
    }
}

