/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.management.search;

import java.util.Collection;
import java.util.LinkedList;
import org.uberfire.ext.security.management.api.AbstractEntityManager;
import org.uberfire.ext.security.management.search.AbstractRuntimeSearchEngine;

public abstract class IdentifierRuntimeSearchEngine<T>
extends AbstractRuntimeSearchEngine<T> {
    public AbstractEntityManager.SearchResponse<T> searchByIdentifiers(Collection<String> entityIdentifiers, AbstractEntityManager.SearchRequest request) {
        LinkedList<String> result;
        if (entityIdentifiers == null || request == null) {
            return null;
        }
        if (request.getPage() <= 0) {
            throw new RuntimeException("First page must be 1.");
        }
        String pattern = request.getSearchPattern();
        boolean isPatternEmpty = this.isEmpty(pattern);
        LinkedList<String> linkedList = result = isPatternEmpty ? entityIdentifiers : new LinkedList<String>();
        if (!isPatternEmpty) {
            for (String id : entityIdentifiers) {
                if (this.isConstrained(request, id) || !id.contains(pattern)) continue;
                result.add(id);
            }
        }
        LinkedList<T> resultEntities = new LinkedList<T>();
        for (String id : result) {
            if (this.isConstrained(request, id)) continue;
            T entity = this.createEntity(id);
            resultEntities.add(entity);
        }
        return this.createResponse(resultEntities, request);
    }

    protected abstract T createEntity(String var1);

    @Override
    protected String getIdentifier(T entity) {
        return null;
    }
}

