/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.project.migration.cli;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.kie.workbench.common.migration.cli.SystemAccess;

public class PromptPomMigrationService {
    private static final String JSON_POM_FILE = "pom-migration.json";
    private SystemAccess system;

    public PromptPomMigrationService(SystemAccess system) {
        this.system = system;
    }

    public String promptForExternalConfiguration() {
        String response;
        SystemAccess.Console console = this.system.console();
        List<String> validResponses = Arrays.asList("yes", "no");
        while (!validResponses.contains(response = console.readLine("Do you want provide a path to an external Pom migration json with dependencies and repositories ? [yes/no]: ", new Object[0]).toLowerCase())) {
        }
        if ("yes".equals(response)) {
            boolean valid = false;
            response = console.readLine("Please provide the path to folder containing the pom-migration.json file : ", new Object[0]).trim();
            do {
                if (!this.jsonExists(response)) {
                    response = console.readLine("The file pom-migration.json doesn't exist in the directory you provided. Please try again :", new Object[0]).trim();
                    continue;
                }
                valid = true;
            } while (response != null && !valid);
            return response + File.separator + JSON_POM_FILE;
        }
        return "";
    }

    private boolean jsonExists(String path) {
        File test = new File(path, JSON_POM_FILE);
        return test.exists() && test.isFile();
    }
}

