/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.script.LeafSearchScript;
import org.elasticsearch.search.SearchHitField;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.subphase.ScriptFieldsContext;
import org.elasticsearch.search.internal.SearchContext;

public final class ScriptFieldsFetchSubPhase
implements FetchSubPhase {
    @Override
    public void hitExecute(SearchContext context, FetchSubPhase.HitContext hitContext) {
        if (!context.hasScriptFields()) {
            return;
        }
        for (ScriptFieldsContext.ScriptField scriptField : context.scriptFields().fields()) {
            SearchHitField hitField;
            Object value;
            LeafSearchScript leafScript;
            try {
                leafScript = scriptField.script().getLeafSearchScript(hitContext.readerContext());
            }
            catch (IOException e1) {
                throw new IllegalStateException("Failed to load script", e1);
            }
            leafScript.setDocument(hitContext.docId());
            try {
                value = leafScript.unwrap(leafScript.run());
                CollectionUtils.ensureNoSelfReferences(value);
            }
            catch (RuntimeException e) {
                if (scriptField.ignoreException()) continue;
                throw e;
            }
            if (hitContext.hit().fieldsOrNull() == null) {
                hitContext.hit().fields(new HashMap<String, SearchHitField>(2));
            }
            if ((hitField = hitContext.hit().fields().get(scriptField.name())) != null) continue;
            List<Object> values = value instanceof Collection ? new ArrayList<Object>((Collection)value) : Collections.singletonList(value);
            hitField = new SearchHitField(scriptField.name(), values);
            hitContext.hit().fields().put(scriptField.name(), hitField);
        }
    }
}

