/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.IntSet;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateApplier;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.RestoreInProgress;
import org.elasticsearch.cluster.SnapshotDeletionsInProgress;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.metadata.MetaDataCreateIndexService;
import org.elasticsearch.cluster.metadata.MetaDataIndexUpgradeService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.RoutingChangesObserver;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.snapshots.ConcurrentSnapshotExecutionException;
import org.elasticsearch.snapshots.RestoreInfo;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotRestoreException;
import org.elasticsearch.snapshots.SnapshotShardFailure;
import org.elasticsearch.snapshots.SnapshotUtils;
import org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class RestoreService
extends AbstractComponent
implements ClusterStateApplier {
    public static Version V_5_1_0_UNRELEASED = Version.fromId(5010099);
    public static final String UPDATE_RESTORE_ACTION_NAME = "internal:cluster/snapshot/update_restore";
    private static final Set<String> UNMODIFIABLE_SETTINGS = Collections.unmodifiableSet(Sets.newHashSet("index.number_of_shards", "index.version.created", "index.uuid", "index.creation_date"));
    private static final Set<String> UNREMOVABLE_SETTINGS;
    private final ClusterService clusterService;
    private final RepositoriesService repositoriesService;
    private final TransportService transportService;
    private final AllocationService allocationService;
    private final MetaDataCreateIndexService createIndexService;
    private final MetaDataIndexUpgradeService metaDataIndexUpgradeService;
    private final ClusterSettings clusterSettings;
    private final CleanRestoreStateTaskExecutor cleanRestoreStateTaskExecutor;

    @Inject
    public RestoreService(Settings settings, ClusterService clusterService, RepositoriesService repositoriesService, TransportService transportService, AllocationService allocationService, MetaDataCreateIndexService createIndexService, MetaDataIndexUpgradeService metaDataIndexUpgradeService, ClusterSettings clusterSettings) {
        super(settings);
        this.clusterService = clusterService;
        this.repositoriesService = repositoriesService;
        this.transportService = transportService;
        this.allocationService = allocationService;
        this.createIndexService = createIndexService;
        this.metaDataIndexUpgradeService = metaDataIndexUpgradeService;
        transportService.registerRequestHandler(UPDATE_RESTORE_ACTION_NAME, UpdateIndexShardRestoreStatusRequest::new, "same", new UpdateRestoreStateRequestHandler());
        clusterService.addStateApplier(this);
        this.clusterSettings = clusterSettings;
        this.cleanRestoreStateTaskExecutor = new CleanRestoreStateTaskExecutor(this.logger);
    }

    public void restoreSnapshot(final RestoreRequest request, final ActionListener<RestoreCompletionResponse> listener) {
        try {
            Repository repository = this.repositoriesService.repository(request.repositoryName);
            RepositoryData repositoryData = repository.getRepositoryData();
            Optional<SnapshotId> incompatibleSnapshotId = repositoryData.getIncompatibleSnapshotIds().stream().filter(s -> request.snapshotName.equals(s.getName())).findFirst();
            if (incompatibleSnapshotId.isPresent()) {
                throw new SnapshotRestoreException(request.repositoryName, request.snapshotName, "cannot restore incompatible snapshot");
            }
            Optional<SnapshotId> matchingSnapshotId = repositoryData.getSnapshotIds().stream().filter(s -> request.snapshotName.equals(s.getName())).findFirst();
            if (!matchingSnapshotId.isPresent()) {
                throw new SnapshotRestoreException(request.repositoryName, request.snapshotName, "snapshot does not exist");
            }
            final SnapshotId snapshotId = matchingSnapshotId.get();
            final SnapshotInfo snapshotInfo = repository.getSnapshotInfo(snapshotId);
            final Snapshot snapshot = new Snapshot(request.repositoryName, snapshotId);
            List<String> filteredIndices = SnapshotUtils.filterIndices(snapshotInfo.indices(), request.indices(), request.indicesOptions());
            MetaData metaDataIn = repository.getSnapshotMetaData(snapshotInfo, repositoryData.resolveIndices(filteredIndices));
            final MetaData metaData = snapshotInfo.version().before(Version.V_2_0_0_beta1) ? MetaData.addDefaultUnitsIfNeeded(this.logger, metaDataIn) : metaDataIn;
            this.validateSnapshotRestorable(request.repositoryName, snapshotInfo);
            final Map<String, String> renamedIndices = this.renamedIndices(request, filteredIndices);
            this.clusterService.submitStateUpdateTask(request.cause(), new ClusterStateUpdateTask(){
                RestoreInfo restoreInfo = null;

                @Override
                public ClusterState execute(ClusterState currentState) {
                    ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shards;
                    RestoreInProgress restoreInProgress = (RestoreInProgress)currentState.custom("restore");
                    if (restoreInProgress != null && !restoreInProgress.entries().isEmpty()) {
                        throw new ConcurrentSnapshotExecutionException(snapshot, "Restore process is already running in this cluster");
                    }
                    SnapshotDeletionsInProgress deletionsInProgress = (SnapshotDeletionsInProgress)currentState.custom("snapshot_deletions");
                    if (deletionsInProgress != null && deletionsInProgress.hasDeletionsInProgress()) {
                        throw new ConcurrentSnapshotExecutionException(snapshot, "cannot restore a snapshot while a snapshot deletion is in-progress [" + deletionsInProgress.getEntries().get(0).getSnapshot() + "]");
                    }
                    ClusterState.Builder builder = ClusterState.builder(currentState);
                    MetaData.Builder mdBuilder = MetaData.builder(currentState.metaData());
                    ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
                    RoutingTable.Builder rtBuilder = RoutingTable.builder(currentState.routingTable());
                    HashSet<String> aliases = new HashSet<String>();
                    if (!renamedIndices.isEmpty()) {
                        ImmutableOpenMap.Builder<ShardId, RestoreInProgress.ShardRestoreStatus> shardsBuilder = ImmutableOpenMap.builder();
                        Version minIndexCompatibilityVersion = currentState.getNodes().getMaxNodeVersion().minimumIndexCompatibilityVersion();
                        for (Map.Entry indexEntry : renamedIndices.entrySet()) {
                            Index renamedIndex;
                            Object updatedIndexMetaData;
                            IndexMetaData.Builder indexMdBuilder;
                            String index = (String)indexEntry.getValue();
                            boolean partial = this.checkPartial(index);
                            RecoverySource.SnapshotRecoverySource recoverySource = new RecoverySource.SnapshotRecoverySource(snapshot, snapshotInfo.version(), index);
                            String renamedIndexName = (String)indexEntry.getKey();
                            IndexMetaData snapshotIndexMetaData = metaData.index(index);
                            snapshotIndexMetaData = this.updateIndexSettings(snapshotIndexMetaData, request.indexSettings, request.ignoreIndexSettings);
                            try {
                                snapshotIndexMetaData = RestoreService.this.metaDataIndexUpgradeService.upgradeIndexMetaData(snapshotIndexMetaData, minIndexCompatibilityVersion);
                            }
                            catch (Exception ex) {
                                throw new SnapshotRestoreException(snapshot, "cannot restore index [" + index + "] because it cannot be upgraded", ex);
                            }
                            IndexMetaData currentIndexMetaData = currentState.metaData().index(renamedIndexName);
                            IntHashSet ignoreShards = new IntHashSet();
                            if (currentIndexMetaData == null) {
                                MetaDataCreateIndexService.validateIndexName(renamedIndexName, currentState);
                                RestoreService.this.createIndexService.validateIndexSettings(renamedIndexName, snapshotIndexMetaData.getSettings());
                                indexMdBuilder = IndexMetaData.builder(snapshotIndexMetaData).state(IndexMetaData.State.OPEN).index(renamedIndexName);
                                indexMdBuilder.settings(Settings.builder().put(snapshotIndexMetaData.getSettings()).put("index.uuid", UUIDs.randomBase64UUID()));
                                if (!request.includeAliases() && !snapshotIndexMetaData.getAliases().isEmpty()) {
                                    indexMdBuilder.removeAllAliases();
                                } else {
                                    for (ObjectCursor alias : snapshotIndexMetaData.getAliases().keys()) {
                                        aliases.add((String)alias.value);
                                    }
                                }
                                updatedIndexMetaData = indexMdBuilder.build();
                                if (partial) {
                                    this.populateIgnoredShards(index, (IntSet)ignoreShards);
                                }
                                rtBuilder.addAsNewRestore((IndexMetaData)updatedIndexMetaData, recoverySource, (IntSet)ignoreShards);
                                blocks.addBlocks((IndexMetaData)updatedIndexMetaData);
                                mdBuilder.put((IndexMetaData)updatedIndexMetaData, true);
                                renamedIndex = ((IndexMetaData)updatedIndexMetaData).getIndex();
                            } else {
                                this.validateExistingIndex(currentIndexMetaData, snapshotIndexMetaData, renamedIndexName, partial);
                                indexMdBuilder = IndexMetaData.builder(snapshotIndexMetaData).state(IndexMetaData.State.OPEN);
                                indexMdBuilder.version(Math.max(snapshotIndexMetaData.getVersion(), currentIndexMetaData.getVersion() + 1L));
                                if (!request.includeAliases()) {
                                    if (!snapshotIndexMetaData.getAliases().isEmpty()) {
                                        indexMdBuilder.removeAllAliases();
                                    }
                                    for (ObjectCursor alias : currentIndexMetaData.getAliases().values()) {
                                        indexMdBuilder.putAlias((AliasMetaData)alias.value);
                                    }
                                } else {
                                    for (ObjectCursor alias : snapshotIndexMetaData.getAliases().keys()) {
                                        aliases.add((String)alias.value);
                                    }
                                }
                                indexMdBuilder.settings(Settings.builder().put(snapshotIndexMetaData.getSettings()).put("index.uuid", currentIndexMetaData.getIndexUUID()));
                                updatedIndexMetaData = indexMdBuilder.index(renamedIndexName).build();
                                rtBuilder.addAsRestore((IndexMetaData)updatedIndexMetaData, recoverySource);
                                blocks.updateBlocks((IndexMetaData)updatedIndexMetaData);
                                mdBuilder.put((IndexMetaData)updatedIndexMetaData, true);
                                renamedIndex = ((IndexMetaData)updatedIndexMetaData).getIndex();
                            }
                            for (int shard = 0; shard < snapshotIndexMetaData.getNumberOfShards(); ++shard) {
                                if (!ignoreShards.contains(shard)) {
                                    shardsBuilder.put(new ShardId(renamedIndex, shard), new RestoreInProgress.ShardRestoreStatus(RestoreService.this.clusterService.state().nodes().getLocalNodeId()));
                                    continue;
                                }
                                shardsBuilder.put(new ShardId(renamedIndex, shard), new RestoreInProgress.ShardRestoreStatus(RestoreService.this.clusterService.state().nodes().getLocalNodeId(), RestoreInProgress.State.FAILURE));
                            }
                        }
                        shards = shardsBuilder.build();
                        RestoreInProgress.Entry restoreEntry = new RestoreInProgress.Entry(snapshot, RestoreService.overallState(RestoreInProgress.State.INIT, shards), Collections.unmodifiableList(new ArrayList(renamedIndices.keySet())), shards);
                        builder.putCustom("restore", new RestoreInProgress(restoreEntry));
                    } else {
                        shards = ImmutableOpenMap.of();
                    }
                    this.checkAliasNameConflicts(renamedIndices, aliases);
                    this.restoreGlobalStateIfRequested(mdBuilder);
                    if (RestoreService.completed(shards)) {
                        this.restoreInfo = new RestoreInfo(snapshotId.getName(), Collections.unmodifiableList(new ArrayList(renamedIndices.keySet())), shards.size(), shards.size() - RestoreService.failedShards(shards));
                    }
                    RoutingTable rt = rtBuilder.build();
                    ClusterState updatedState = builder.metaData(mdBuilder).blocks(blocks).routingTable(rt).build();
                    return RestoreService.this.allocationService.reroute(updatedState, "restored snapshot [" + snapshot + "]");
                }

                private void checkAliasNameConflicts(Map<String, String> renamedIndices2, Set<String> aliases) {
                    for (Map.Entry<String, String> renamedIndex : renamedIndices2.entrySet()) {
                        if (!aliases.contains(renamedIndex.getKey())) continue;
                        throw new SnapshotRestoreException(snapshot, "cannot rename index [" + renamedIndex.getValue() + "] into [" + renamedIndex.getKey() + "] because of conflict with an alias with the same name");
                    }
                }

                private void populateIgnoredShards(String index, IntSet ignoreShards) {
                    for (SnapshotShardFailure failure : snapshotInfo.shardFailures()) {
                        if (!index.equals(failure.index())) continue;
                        ignoreShards.add(failure.shardId());
                    }
                }

                private boolean checkPartial(String index) {
                    if (RestoreService.this.failed(snapshotInfo, index)) {
                        if (request.partial()) {
                            return true;
                        }
                        throw new SnapshotRestoreException(snapshot, "index [" + index + "] wasn't fully snapshotted - cannot restore");
                    }
                    return false;
                }

                private void validateExistingIndex(IndexMetaData currentIndexMetaData, IndexMetaData snapshotIndexMetaData, String renamedIndex, boolean partial) {
                    if (currentIndexMetaData.getState() != IndexMetaData.State.CLOSE) {
                        throw new SnapshotRestoreException(snapshot, "cannot restore index [" + renamedIndex + "] because it's open");
                    }
                    if (partial) {
                        throw new SnapshotRestoreException(snapshot, "cannot restore partial index [" + renamedIndex + "] because such index already exists");
                    }
                    if (currentIndexMetaData.getNumberOfShards() != snapshotIndexMetaData.getNumberOfShards()) {
                        throw new SnapshotRestoreException(snapshot, "cannot restore index [" + renamedIndex + "] with [" + currentIndexMetaData.getNumberOfShards() + "] shard from snapshot with [" + snapshotIndexMetaData.getNumberOfShards() + "] shards");
                    }
                }

                private IndexMetaData updateIndexSettings(IndexMetaData indexMetaData, Settings changeSettings, String[] ignoreSettings) {
                    if (changeSettings.names().isEmpty() && ignoreSettings.length == 0) {
                        return indexMetaData;
                    }
                    Settings normalizedChangeSettings = Settings.builder().put(changeSettings).normalizePrefix("index.").build();
                    IndexMetaData.Builder builder = IndexMetaData.builder(indexMetaData);
                    HashMap<String, String> settingsMap = new HashMap<String, String>(indexMetaData.getSettings().getAsMap());
                    ArrayList<String> simpleMatchPatterns = new ArrayList<String>();
                    for (String ignoredSetting : ignoreSettings) {
                        if (!Regex.isSimpleMatchPattern(ignoredSetting)) {
                            if (UNREMOVABLE_SETTINGS.contains(ignoredSetting)) {
                                throw new SnapshotRestoreException(snapshot, "cannot remove setting [" + ignoredSetting + "] on restore");
                            }
                            settingsMap.remove(ignoredSetting);
                            continue;
                        }
                        simpleMatchPatterns.add(ignoredSetting);
                    }
                    if (!simpleMatchPatterns.isEmpty()) {
                        String[] removePatterns = simpleMatchPatterns.toArray(new String[simpleMatchPatterns.size()]);
                        Iterator iterator = settingsMap.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry entry = iterator.next();
                            if (UNREMOVABLE_SETTINGS.contains(entry.getKey()) || !Regex.simpleMatch(removePatterns, (String)entry.getKey())) continue;
                            iterator.remove();
                        }
                    }
                    for (Map.Entry entry : normalizedChangeSettings.getAsMap().entrySet()) {
                        if (UNMODIFIABLE_SETTINGS.contains(entry.getKey())) {
                            throw new SnapshotRestoreException(snapshot, "cannot modify setting [" + (String)entry.getKey() + "] on restore");
                        }
                        settingsMap.put((String)entry.getKey(), (String)entry.getValue());
                    }
                    return builder.settings(Settings.builder().put(settingsMap)).build();
                }

                private void restoreGlobalStateIfRequested(MetaData.Builder mdBuilder) {
                    if (request.includeGlobalState()) {
                        if (metaData.persistentSettings() != null) {
                            Settings settings = metaData.persistentSettings();
                            RestoreService.this.clusterSettings.validateUpdate(settings);
                            mdBuilder.persistentSettings(settings);
                        }
                        if (metaData.templates() != null) {
                            for (ObjectObjectCursor<String, MetaData.Custom> cursor : metaData.templates().values()) {
                                mdBuilder.put((IndexTemplateMetaData)cursor.value);
                            }
                        }
                        if (metaData.customs() != null) {
                            for (ObjectObjectCursor<String, MetaData.Custom> cursor : metaData.customs()) {
                                if ("repositories".equals(cursor.key)) continue;
                                mdBuilder.putCustom((String)cursor.key, (MetaData.Custom)cursor.value);
                            }
                        }
                    }
                }

                @Override
                public void onFailure(String source, Exception e) {
                    RestoreService.this.logger.warn(() -> new ParameterizedMessage("[{}] failed to restore snapshot", (Object)snapshotId), (Throwable)e);
                    listener.onFailure(e);
                }

                @Override
                public TimeValue timeout() {
                    return request.masterNodeTimeout();
                }

                @Override
                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    listener.onResponse(new RestoreCompletionResponse(snapshot, this.restoreInfo));
                }
            });
        }
        catch (Exception e) {
            this.logger.warn(() -> new ParameterizedMessage("[{}] failed to restore snapshot", (Object)(request.repositoryName + ":" + request.snapshotName)), (Throwable)e);
            listener.onFailure(e);
        }
    }

    public static RestoreInProgress updateRestoreStateWithDeletedIndices(RestoreInProgress oldRestore, Set<Index> deletedIndices) {
        boolean changesMade = false;
        ArrayList<RestoreInProgress.Entry> entries = new ArrayList<RestoreInProgress.Entry>();
        for (RestoreInProgress.Entry entry : oldRestore.entries()) {
            ImmutableOpenMap.Builder<ShardId, RestoreInProgress.ShardRestoreStatus> shardsBuilder = null;
            for (ObjectObjectCursor<ShardId, RestoreInProgress.ShardRestoreStatus> objectObjectCursor : entry.shards()) {
                ShardId shardId = (ShardId)objectObjectCursor.key;
                if (!deletedIndices.contains(shardId.getIndex())) continue;
                changesMade = true;
                if (shardsBuilder == null) {
                    shardsBuilder = ImmutableOpenMap.builder(entry.shards());
                }
                shardsBuilder.put(shardId, new RestoreInProgress.ShardRestoreStatus(null, RestoreInProgress.State.FAILURE, "index was deleted"));
            }
            if (shardsBuilder != null) {
                ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shards = shardsBuilder.build();
                entries.add(new RestoreInProgress.Entry(entry.snapshot(), RestoreService.overallState(RestoreInProgress.State.STARTED, shards), entry.indices(), shards));
                continue;
            }
            entries.add(entry);
        }
        if (changesMade) {
            return new RestoreInProgress(entries.toArray(new RestoreInProgress.Entry[entries.size()]));
        }
        return oldRestore;
    }

    public static RestoreInProgress.Entry restoreInProgress(ClusterState state, Snapshot snapshot) {
        RestoreInProgress restoreInProgress = (RestoreInProgress)state.custom("restore");
        if (restoreInProgress != null) {
            for (RestoreInProgress.Entry e : restoreInProgress.entries()) {
                if (!e.snapshot().equals(snapshot)) continue;
                return e;
            }
        }
        return null;
    }

    private void cleanupRestoreState(ClusterChangedEvent event) {
        ClusterState state = event.state();
        RestoreInProgress restoreInProgress = (RestoreInProgress)state.custom("restore");
        if (restoreInProgress != null) {
            for (RestoreInProgress.Entry entry : restoreInProgress.entries()) {
                if (!entry.state().completed()) continue;
                assert (RestoreService.completed(entry.shards())) : "state says completed but restore entries are not";
                this.clusterService.submitStateUpdateTask("clean up snapshot restore state", new CleanRestoreStateTaskExecutor.Task(entry.snapshot()), ClusterStateTaskConfig.build(Priority.URGENT), this.cleanRestoreStateTaskExecutor, this.cleanRestoreStateTaskExecutor);
            }
            if (event.localNodeMaster() && !event.previousState().nodes().isLocalNodeElectedMaster()) {
                this.clusterService.submitStateUpdateTask("update restore state after master switch", new ClusterStateUpdateTask(){

                    @Override
                    public ClusterState execute(ClusterState currentState) throws Exception {
                        return RestoreService.this.resyncRestoreInProgressWithRoutingTable(currentState);
                    }

                    @Override
                    public void onFailure(String source, Exception e) {
                        RestoreService.this.logger.warn("failed to sync restore state after master switch", (Throwable)e);
                    }
                });
            }
        }
    }

    private ClusterState resyncRestoreInProgressWithRoutingTable(ClusterState currentState) {
        RoutingTable routingTable = currentState.routingTable();
        RestoreInProgress restoreInProgress = (RestoreInProgress)currentState.custom("restore");
        if (restoreInProgress != null) {
            ArrayList<RestoreInProgress.Entry> entries = new ArrayList<RestoreInProgress.Entry>();
            for (RestoreInProgress.Entry entry : restoreInProgress.entries()) {
                Snapshot snapshot = entry.snapshot();
                ImmutableOpenMap.Builder<ShardId, RestoreInProgress.ShardRestoreStatus> shardsBuilder = ImmutableOpenMap.builder(entry.shards());
                for (ObjectObjectCursor<ShardId, RestoreInProgress.ShardRestoreStatus> objectObjectCursor : entry.shards()) {
                    ShardId shardId = (ShardId)objectObjectCursor.key;
                    IndexShardRoutingTable indexShardRoutingTable = routingTable.shardRoutingTableOrNull(shardId);
                    if (indexShardRoutingTable == null) {
                        shardsBuilder.put(shardId, new RestoreInProgress.ShardRestoreStatus(null, RestoreInProgress.State.FAILURE, "index was deleted"));
                        continue;
                    }
                    if (((RestoreInProgress.ShardRestoreStatus)objectObjectCursor.value).state().completed()) continue;
                    assert (((RestoreInProgress.ShardRestoreStatus)objectObjectCursor.value).state() == RestoreInProgress.State.INIT);
                    ShardRouting primaryShard = indexShardRoutingTable.primaryShard();
                    if (primaryShard.active()) {
                        shardsBuilder.put(shardId, new RestoreInProgress.ShardRestoreStatus(primaryShard.currentNodeId(), RestoreInProgress.State.SUCCESS));
                        continue;
                    }
                    assert (primaryShard.unassigned() || primaryShard.initializing());
                    if (primaryShard.recoverySource().getType() == RecoverySource.Type.SNAPSHOT && ((RecoverySource.SnapshotRecoverySource)primaryShard.recoverySource()).snapshot().equals(snapshot)) continue;
                    shardsBuilder.put(shardId, new RestoreInProgress.ShardRestoreStatus(null, RestoreInProgress.State.FAILURE, "recovery source type changed from snapshot to " + primaryShard.recoverySource()));
                }
                ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shards = shardsBuilder.build();
                RestoreInProgress.State state = RestoreService.overallState(RestoreInProgress.State.STARTED, shards);
                entries.add(new RestoreInProgress.Entry(entry.snapshot(), state, entry.indices(), shards));
            }
            RestoreInProgress updatedRestoreInProgress = new RestoreInProgress(entries.toArray(new RestoreInProgress.Entry[entries.size()]));
            ImmutableOpenMap.Builder<String, ClusterState.Custom> builder = ImmutableOpenMap.builder(currentState.getCustoms());
            builder.put("restore", updatedRestoreInProgress);
            ImmutableOpenMap<String, ClusterState.Custom> customs = builder.build();
            return ClusterState.builder(currentState).customs(customs).build();
        }
        return currentState;
    }

    public static RestoreInProgress.State overallState(RestoreInProgress.State nonCompletedState, ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shards) {
        boolean hasFailed = false;
        for (ObjectCursor status : shards.values()) {
            if (!((RestoreInProgress.ShardRestoreStatus)status.value).state().completed()) {
                return nonCompletedState;
            }
            if (((RestoreInProgress.ShardRestoreStatus)status.value).state() != RestoreInProgress.State.FAILURE) continue;
            hasFailed = true;
        }
        if (hasFailed) {
            return RestoreInProgress.State.FAILURE;
        }
        return RestoreInProgress.State.SUCCESS;
    }

    public static boolean completed(ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shards) {
        for (ObjectCursor status : shards.values()) {
            if (((RestoreInProgress.ShardRestoreStatus)status.value).state().completed()) continue;
            return false;
        }
        return true;
    }

    public static int failedShards(ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shards) {
        int failedShards = 0;
        for (ObjectCursor status : shards.values()) {
            if (((RestoreInProgress.ShardRestoreStatus)status.value).state() != RestoreInProgress.State.FAILURE) continue;
            ++failedShards;
        }
        return failedShards;
    }

    private Map<String, String> renamedIndices(RestoreRequest request, List<String> filteredIndices) {
        HashMap<String, String> renamedIndices = new HashMap<String, String>();
        Iterator<String> iterator = filteredIndices.iterator();
        while (iterator.hasNext()) {
            String previousIndex;
            String index;
            String renamedIndex = index = iterator.next();
            if (request.renameReplacement() != null && request.renamePattern() != null) {
                renamedIndex = index.replaceAll(request.renamePattern(), request.renameReplacement());
            }
            if ((previousIndex = renamedIndices.put(renamedIndex, index)) == null) continue;
            throw new SnapshotRestoreException(request.repositoryName, request.snapshotName, "indices [" + index + "] and [" + previousIndex + "] are renamed into the same index [" + renamedIndex + "]");
        }
        return renamedIndices;
    }

    private void validateSnapshotRestorable(String repository, SnapshotInfo snapshotInfo) {
        if (!snapshotInfo.state().restorable()) {
            throw new SnapshotRestoreException(new Snapshot(repository, snapshotInfo.snapshotId()), "unsupported snapshot state [" + (Object)((Object)snapshotInfo.state()) + "]");
        }
        if (Version.CURRENT.before(snapshotInfo.version())) {
            throw new SnapshotRestoreException(new Snapshot(repository, snapshotInfo.snapshotId()), "the snapshot was created with Elasticsearch version [" + snapshotInfo.version() + "] which is higher than the version of this node [" + Version.CURRENT + "]");
        }
    }

    public void indexShardRestoreCompleted(Snapshot snapshot, ShardId shardId) {
        this.logger.trace("[{}] successfully restored shard  [{}]", (Object)snapshot, (Object)shardId);
        DiscoveryNode masterNode = this.clusterService.state().nodes().getMasterNode();
        if (masterNode != null && masterNode.getVersion().before(V_5_1_0_UNRELEASED)) {
            UpdateIndexShardRestoreStatusRequest request = new UpdateIndexShardRestoreStatusRequest(snapshot, shardId, new RestoreInProgress.ShardRestoreStatus(this.clusterService.state().nodes().getLocalNodeId(), RestoreInProgress.State.SUCCESS));
            this.transportService.sendRequest(masterNode, UPDATE_RESTORE_ACTION_NAME, request, EmptyTransportResponseHandler.INSTANCE_SAME);
        }
    }

    public void failRestore(Snapshot snapshot, ShardId shardId) {
        this.logger.debug("[{}] failed to restore shard  [{}]", (Object)snapshot, (Object)shardId);
        DiscoveryNode masterNode = this.clusterService.state().nodes().getMasterNode();
        if (masterNode != null && masterNode.getVersion().before(V_5_1_0_UNRELEASED)) {
            UpdateIndexShardRestoreStatusRequest request = new UpdateIndexShardRestoreStatusRequest(snapshot, shardId, new RestoreInProgress.ShardRestoreStatus(this.clusterService.state().nodes().getLocalNodeId(), RestoreInProgress.State.FAILURE));
            this.transportService.sendRequest(masterNode, UPDATE_RESTORE_ACTION_NAME, request, EmptyTransportResponseHandler.INSTANCE_SAME);
        }
    }

    private boolean failed(SnapshotInfo snapshot, String index) {
        for (SnapshotShardFailure failure : snapshot.shardFailures()) {
            if (!index.equals(failure.index())) continue;
            return true;
        }
        return false;
    }

    public static void checkIndexClosing(ClusterState currentState, Set<IndexMetaData> indices) {
        RestoreInProgress restore = (RestoreInProgress)currentState.custom("restore");
        if (restore != null) {
            HashSet<Index> indicesToFail = null;
            for (RestoreInProgress.Entry entry : restore.entries()) {
                for (ObjectObjectCursor<ShardId, RestoreInProgress.ShardRestoreStatus> objectObjectCursor : entry.shards()) {
                    IndexMetaData indexMetaData;
                    if (((RestoreInProgress.ShardRestoreStatus)objectObjectCursor.value).state().completed() || (indexMetaData = currentState.metaData().index(((ShardId)objectObjectCursor.key).getIndex())) == null || !indices.contains(indexMetaData)) continue;
                    if (indicesToFail == null) {
                        indicesToFail = new HashSet<Index>();
                    }
                    indicesToFail.add(((ShardId)objectObjectCursor.key).getIndex());
                }
            }
            if (indicesToFail != null) {
                throw new IllegalArgumentException("Cannot close indices that are being restored: " + indicesToFail);
            }
        }
    }

    @Override
    public void applyClusterState(ClusterChangedEvent event) {
        try {
            if (event.localNodeMaster()) {
                this.cleanupRestoreState(event);
            }
        }
        catch (Exception t) {
            this.logger.warn("Failed to update restore state ", (Throwable)t);
        }
    }

    public static boolean isRepositoryInUse(ClusterState clusterState, String repository) {
        RestoreInProgress snapshots = (RestoreInProgress)clusterState.custom("restore");
        if (snapshots != null) {
            for (RestoreInProgress.Entry snapshot : snapshots.entries()) {
                if (!repository.equals(snapshot.snapshot().getRepository())) continue;
                return true;
            }
        }
        return false;
    }

    static {
        HashSet<String> unremovable = new HashSet<String>(UNMODIFIABLE_SETTINGS.size() + 4);
        unremovable.addAll(UNMODIFIABLE_SETTINGS);
        unremovable.add("index.number_of_replicas");
        unremovable.add("index.auto_expand_replicas");
        unremovable.add("index.version.upgraded");
        UNREMOVABLE_SETTINGS = Collections.unmodifiableSet(unremovable);
    }

    class UpdateRestoreStateRequestHandler
    implements TransportRequestHandler<UpdateIndexShardRestoreStatusRequest> {
        UpdateRestoreStateRequestHandler() {
        }

        @Override
        public void messageReceived(UpdateIndexShardRestoreStatusRequest request, TransportChannel channel) throws Exception {
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }
    }

    public static class UpdateIndexShardRestoreStatusRequest
    extends TransportRequest {
        private Snapshot snapshot;
        private ShardId shardId;
        private RestoreInProgress.ShardRestoreStatus status;
        volatile boolean processed;

        public UpdateIndexShardRestoreStatusRequest() {
        }

        private UpdateIndexShardRestoreStatusRequest(Snapshot snapshot, ShardId shardId, RestoreInProgress.ShardRestoreStatus status) {
            this.snapshot = snapshot;
            this.shardId = shardId;
            this.status = status;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.snapshot = new Snapshot(in);
            this.shardId = ShardId.readShardId(in);
            this.status = RestoreInProgress.ShardRestoreStatus.readShardRestoreStatus(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.snapshot.writeTo(out);
            this.shardId.writeTo(out);
            this.status.writeTo(out);
        }

        public Snapshot snapshot() {
            return this.snapshot;
        }

        public ShardId shardId() {
            return this.shardId;
        }

        public RestoreInProgress.ShardRestoreStatus status() {
            return this.status;
        }

        public String toString() {
            return "" + this.snapshot + ", shardId [" + this.shardId + "], status [" + (Object)((Object)this.status.state()) + "]";
        }
    }

    public static class RestoreRequest {
        private final String cause;
        private final String repositoryName;
        private final String snapshotName;
        private final String[] indices;
        private final String renamePattern;
        private final String renameReplacement;
        private final IndicesOptions indicesOptions;
        private final Settings settings;
        private final TimeValue masterNodeTimeout;
        private final boolean includeGlobalState;
        private final boolean partial;
        private final boolean includeAliases;
        private final Settings indexSettings;
        private final String[] ignoreIndexSettings;

        public RestoreRequest(String repositoryName, String snapshotName, String[] indices, IndicesOptions indicesOptions, String renamePattern, String renameReplacement, Settings settings, TimeValue masterNodeTimeout, boolean includeGlobalState, boolean partial, boolean includeAliases, Settings indexSettings, String[] ignoreIndexSettings, String cause) {
            this.repositoryName = Objects.requireNonNull(repositoryName);
            this.snapshotName = Objects.requireNonNull(snapshotName);
            this.indices = indices;
            this.renamePattern = renamePattern;
            this.renameReplacement = renameReplacement;
            this.indicesOptions = indicesOptions;
            this.settings = settings;
            this.masterNodeTimeout = masterNodeTimeout;
            this.includeGlobalState = includeGlobalState;
            this.partial = partial;
            this.includeAliases = includeAliases;
            this.indexSettings = indexSettings;
            this.ignoreIndexSettings = ignoreIndexSettings;
            this.cause = cause;
        }

        public String cause() {
            return this.cause;
        }

        public String repositoryName() {
            return this.repositoryName;
        }

        public String snapshotName() {
            return this.snapshotName;
        }

        public String[] indices() {
            return this.indices;
        }

        public IndicesOptions indicesOptions() {
            return this.indicesOptions;
        }

        public String renamePattern() {
            return this.renamePattern;
        }

        public String renameReplacement() {
            return this.renameReplacement;
        }

        public Settings settings() {
            return this.settings;
        }

        public boolean includeGlobalState() {
            return this.includeGlobalState;
        }

        public boolean partial() {
            return this.partial;
        }

        public boolean includeAliases() {
            return this.includeAliases;
        }

        public Settings indexSettings() {
            return this.indexSettings;
        }

        public String[] ignoreIndexSettings() {
            return this.ignoreIndexSettings;
        }

        public TimeValue masterNodeTimeout() {
            return this.masterNodeTimeout;
        }
    }

    static class CleanRestoreStateTaskExecutor
    implements ClusterStateTaskExecutor<Task>,
    ClusterStateTaskListener {
        private final Logger logger;

        CleanRestoreStateTaskExecutor(Logger logger) {
            this.logger = logger;
        }

        @Override
        public ClusterStateTaskExecutor.ClusterTasksResult<Task> execute(ClusterState currentState, List<Task> tasks) throws Exception {
            ClusterStateTaskExecutor.ClusterTasksResult.Builder<Task> resultBuilder = ClusterStateTaskExecutor.ClusterTasksResult.builder().successes(tasks);
            Set completedSnapshots = tasks.stream().map(e -> e.snapshot).collect(Collectors.toSet());
            ArrayList<RestoreInProgress.Entry> entries = new ArrayList<RestoreInProgress.Entry>();
            RestoreInProgress restoreInProgress = (RestoreInProgress)currentState.custom("restore");
            boolean changed = false;
            if (restoreInProgress != null) {
                for (RestoreInProgress.Entry entry : restoreInProgress.entries()) {
                    if (!completedSnapshots.contains(entry.snapshot())) {
                        entries.add(entry);
                        continue;
                    }
                    changed = true;
                }
            }
            if (!changed) {
                return resultBuilder.build(currentState);
            }
            RestoreInProgress updatedRestoreInProgress = new RestoreInProgress(entries.toArray(new RestoreInProgress.Entry[entries.size()]));
            ImmutableOpenMap.Builder<String, ClusterState.Custom> builder = ImmutableOpenMap.builder(currentState.getCustoms());
            builder.put("restore", updatedRestoreInProgress);
            ImmutableOpenMap<String, ClusterState.Custom> customs = builder.build();
            return resultBuilder.build(ClusterState.builder(currentState).customs(customs).build());
        }

        @Override
        public void onFailure(String source, Exception e) {
            this.logger.error(() -> new ParameterizedMessage("unexpected failure during [{}]", (Object)source), (Throwable)e);
        }

        @Override
        public void onNoLongerMaster(String source) {
            this.logger.debug("no longer master while processing restore state update [{}]", (Object)source);
        }

        static class Task {
            final Snapshot snapshot;

            Task(Snapshot snapshot) {
                this.snapshot = snapshot;
            }

            public String toString() {
                return "clean restore state for restoring snapshot " + this.snapshot;
            }
        }
    }

    public static class RestoreInProgressUpdater
    extends RoutingChangesObserver.AbstractRoutingChangesObserver {
        private final Map<Snapshot, Updates> shardChanges = new HashMap<Snapshot, Updates>();

        @Override
        public void shardStarted(ShardRouting initializingShard, ShardRouting startedShard) {
            RecoverySource recoverySource;
            if (initializingShard.primary() && (recoverySource = initializingShard.recoverySource()).getType() == RecoverySource.Type.SNAPSHOT) {
                Snapshot snapshot = ((RecoverySource.SnapshotRecoverySource)recoverySource).snapshot();
                this.changes(snapshot).shards.put(initializingShard.shardId(), new RestoreInProgress.ShardRestoreStatus(initializingShard.currentNodeId(), RestoreInProgress.State.SUCCESS));
            }
        }

        @Override
        public void shardFailed(ShardRouting failedShard, UnassignedInfo unassignedInfo) {
            RecoverySource recoverySource;
            if (failedShard.primary() && failedShard.initializing() && (recoverySource = failedShard.recoverySource()).getType() == RecoverySource.Type.SNAPSHOT) {
                Snapshot snapshot = ((RecoverySource.SnapshotRecoverySource)recoverySource).snapshot();
                if (unassignedInfo.getFailure() != null && Lucene.isCorruptionException(unassignedInfo.getFailure().getCause())) {
                    this.changes(snapshot).shards.put(failedShard.shardId(), new RestoreInProgress.ShardRestoreStatus(failedShard.currentNodeId(), RestoreInProgress.State.FAILURE, unassignedInfo.getFailure().getCause().getMessage()));
                }
            }
        }

        @Override
        public void shardInitialized(ShardRouting unassignedShard, ShardRouting initializedShard) {
            if (unassignedShard.recoverySource().getType() == RecoverySource.Type.SNAPSHOT && initializedShard.recoverySource().getType() != RecoverySource.Type.SNAPSHOT) {
                Snapshot snapshot = ((RecoverySource.SnapshotRecoverySource)unassignedShard.recoverySource()).snapshot();
                this.changes(snapshot).shards.put(unassignedShard.shardId(), new RestoreInProgress.ShardRestoreStatus(null, RestoreInProgress.State.FAILURE, "recovery source type changed from snapshot to " + initializedShard.recoverySource()));
            }
        }

        @Override
        public void unassignedInfoUpdated(ShardRouting unassignedShard, UnassignedInfo newUnassignedInfo) {
            RecoverySource recoverySource = unassignedShard.recoverySource();
            if (recoverySource.getType() == RecoverySource.Type.SNAPSHOT && newUnassignedInfo.getLastAllocationStatus() == UnassignedInfo.AllocationStatus.DECIDERS_NO) {
                Snapshot snapshot = ((RecoverySource.SnapshotRecoverySource)recoverySource).snapshot();
                String reason = "shard could not be allocated to any of the nodes";
                this.changes(snapshot).shards.put(unassignedShard.shardId(), new RestoreInProgress.ShardRestoreStatus(unassignedShard.currentNodeId(), RestoreInProgress.State.FAILURE, reason));
            }
        }

        private Updates changes(Snapshot snapshot) {
            return this.shardChanges.computeIfAbsent(snapshot, k -> new Updates());
        }

        public RestoreInProgress applyChanges(RestoreInProgress oldRestore) {
            if (!this.shardChanges.isEmpty()) {
                ArrayList<RestoreInProgress.Entry> entries = new ArrayList<RestoreInProgress.Entry>();
                for (RestoreInProgress.Entry entry : oldRestore.entries()) {
                    Snapshot snapshot = entry.snapshot();
                    Updates updates = this.shardChanges.get(snapshot);
                    if (!updates.shards.isEmpty()) {
                        ImmutableOpenMap.Builder<ShardId, RestoreInProgress.ShardRestoreStatus> shardsBuilder = ImmutableOpenMap.builder(entry.shards());
                        for (Map.Entry shard : updates.shards.entrySet()) {
                            shardsBuilder.put((ShardId)shard.getKey(), (RestoreInProgress.ShardRestoreStatus)shard.getValue());
                        }
                        ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shards = shardsBuilder.build();
                        RestoreInProgress.State newState = RestoreService.overallState(RestoreInProgress.State.STARTED, shards);
                        entries.add(new RestoreInProgress.Entry(entry.snapshot(), newState, entry.indices(), shards));
                        continue;
                    }
                    entries.add(entry);
                }
                return new RestoreInProgress(entries.toArray(new RestoreInProgress.Entry[entries.size()]));
            }
            return oldRestore;
        }

        private static class Updates {
            private Map<ShardId, RestoreInProgress.ShardRestoreStatus> shards = new HashMap<ShardId, RestoreInProgress.ShardRestoreStatus>();

            private Updates() {
            }
        }
    }

    public static final class RestoreCompletionResponse {
        private final Snapshot snapshot;
        private final RestoreInfo restoreInfo;

        private RestoreCompletionResponse(Snapshot snapshot, RestoreInfo restoreInfo) {
            this.snapshot = snapshot;
            this.restoreInfo = restoreInfo;
        }

        public Snapshot getSnapshot() {
            return this.snapshot;
        }

        public RestoreInfo getRestoreInfo() {
            return this.restoreInfo;
        }
    }
}

