/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.migration.legacy.services;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kie.workbench.common.forms.migration.legacy.model.FieldType;
import org.kie.workbench.common.forms.migration.legacy.services.impl.FieldTypeBuilder;

public class FieldTypeManager {
    private static FieldTypeManager instance;
    private List<FieldType> fieldTypes;
    private List<FieldType> decoratorTypes;
    private List<FieldType> complexTypes;
    protected FieldType customType = new FieldType();

    private FieldTypeManager() {
        this.fieldTypes = FieldTypeBuilder.getSimpleFieldTypes();
        this.complexTypes = FieldTypeBuilder.getComplexTypesList();
        this.decoratorTypes = FieldTypeBuilder.getDecoratorTypesList();
        this.customType.setCode("CustomInput");
        this.customType.setFieldClass("*");
        this.customType.setManagerClass("org.jbpm.formModeler.core.processing.fieldHandlers.customInput.CustomInputFieldHandler");
    }

    public FieldType getTypeByCode(String typeCode, String fieldClass) {
        if (this.customType.getCode().equals(typeCode)) {
            FieldType ft = new FieldType(this.customType);
            ft.setFieldClass(fieldClass);
            return ft;
        }
        for (FieldType fieldType : this.fieldTypes) {
            if (!fieldType.getCode().equals(typeCode)) continue;
            return fieldType;
        }
        for (FieldType decorator : this.decoratorTypes) {
            if (!decorator.getCode().equals(typeCode)) continue;
            return decorator;
        }
        for (FieldType complexType : this.complexTypes) {
            if (!complexType.getCode().equals(typeCode)) continue;
            return complexType;
        }
        return null;
    }

    public FieldType getTypeByCode(String typeCode) {
        return this.getTypeByCode(typeCode, null);
    }

    public FieldType getTypeByClass(String className) {
        return this.getTypeByClass(className, null);
    }

    public FieldType getTypeByClass(String className, String bag) {
        if (StringUtils.isEmpty((CharSequence)className)) {
            return null;
        }
        if (!StringUtils.isEmpty((CharSequence)bag)) {
            if (this.getSimpleTypeByClass(bag) != null) {
                return this.getSimpleTypeByClass(className);
            }
            return this.getComplexTypeByClass(className);
        }
        FieldType fieldType = this.getSimpleTypeByClass(className);
        if (fieldType != null) {
            return fieldType;
        }
        fieldType = this.getDecoratorTypeByClass(className);
        if (fieldType != null) {
            return fieldType;
        }
        fieldType = this.getComplexTypeByClass(className);
        if (fieldType != null) {
            return fieldType;
        }
        return this.getTypeByCode("Subform");
    }

    public FieldType getSimpleTypeByClass(String className) {
        return this.getFieldTypeByClass(this.fieldTypes, className);
    }

    public FieldType getComplexTypeByClass(String className) {
        return this.getFieldTypeByClass(this.complexTypes, className);
    }

    public FieldType getDecoratorTypeByClass(String className) {
        return this.getFieldTypeByClass(this.decoratorTypes, className);
    }

    protected FieldType getFieldTypeByClass(List<FieldType> fieldTypes, String className) {
        for (FieldType fieldType : fieldTypes) {
            if (!fieldType.getFieldClass().equals(className)) continue;
            return fieldType;
        }
        return null;
    }

    public static FieldTypeManager get() {
        if (instance == null) {
            instance = new FieldTypeManager();
        }
        return instance;
    }
}

