/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.forms.model.impl;

import java.util.ArrayList;
import java.util.List;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.forms.model.FormModel;
import org.kie.workbench.common.forms.model.ModelProperty;
import org.kie.workbench.common.forms.model.TypeKind;
import org.kie.workbench.common.forms.model.impl.ModelPropertyImpl;
import org.kie.workbench.common.forms.model.impl.TypeInfoImpl;

public abstract class AbstractFormModel
implements FormModel {
    protected String name;
    protected List<ModelProperty> properties = new ArrayList<ModelProperty>();

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public List<ModelProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(List<ModelProperty> properties) {
        this.properties = properties;
    }

    @Override
    public ModelProperty getProperty(String name) {
        return this.properties.stream().filter(property -> property.getName().equals(name)).findFirst().orElse(null);
    }

    public void addProperty(String name, String className) {
        this.addProperty(new ModelPropertyImpl(name, new TypeInfoImpl(className)));
    }

    public void addProperty(String name, String className, TypeKind typeKind, boolean multiple) {
        this.addProperty(new ModelPropertyImpl(name, new TypeInfoImpl(typeKind, className, multiple)));
    }

    public void addProperty(ModelProperty property) {
        PortablePreconditions.checkNotNull((String)"property", (Object)property);
        if (this.getProperty(property.getName()) != null) {
            throw new IllegalArgumentException("The model already has a '" + property.getName() + "' property.");
        }
        this.properties.add(property);
    }
}

