/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.healthcheck;

import java.net.URI;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.kie.workbench.common.services.backend.healthcheck.ServiceCheck;
import org.kie.workbench.common.services.backend.healthcheck.ServiceStatus;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;

@ApplicationScoped
public class IoServiceCheck
implements ServiceCheck {
    private final IOService ioService;

    @Inject
    public IoServiceCheck(@Named(value="configIO") IOService ioService) {
        this.ioService = ioService;
    }

    @Override
    public ServiceStatus getStatus() {
        try {
            return this.systemFsExists() ? ServiceStatus.HEALTHY : ServiceStatus.UNHEALTHY;
        }
        catch (Exception e) {
            return ServiceStatus.INCONCLUSIVE;
        }
    }

    boolean systemFsExists() {
        try {
            FileSystem fileSystem = this.getFileSystem();
            if (fileSystem == null) {
                return false;
            }
            return fileSystem.isOpen();
        }
        catch (Exception e) {
            return false;
        }
    }

    FileSystem getFileSystem() {
        return this.ioService.getFileSystem(URI.create("default://system/system"));
    }

    @Override
    public String getName() {
        return "IO Service / File System";
    }
}

