/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.pom;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryPolicy;
import org.kie.workbench.common.services.backend.pom.JSONDTO;
import org.kie.workbench.common.services.backend.pom.RepositoryKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PomJsonReader {
    private final Logger logger = LoggerFactory.getLogger(PomJsonReader.class);
    private String jsonPomFile;
    private String DEPENDENCIES = "dependencies";
    private String REPOSITORIES_ADD = "repositories-add";
    private String REPOSITORIES_REMOVE = "repositories-remove";
    private String REPOSITORIES_UPDATE_URLS = "repositories-update-urls";
    private String PLUGIN_REPOSITORIES_ADD = "pluginRepositories-add";
    private String PLUGIN_REPOSITORIES_REMOVE = "pluginRepositories-remove";
    private String PLUGIN_REPOSITORIES_UPDATE_URLS = "pluginRepositories-update-urls";
    private JsonObject pomObject;

    public PomJsonReader(String path, String jsonName) {
        this.jsonPomFile = jsonName;
        if (!path.endsWith(this.jsonPomFile)) {
            throw new RuntimeException("no " + this.jsonPomFile + " in the provided path :" + path);
        }
        FileInputStream fis = null;
        JsonReader reader = null;
        try {
            fis = new FileInputStream(path);
            reader = Json.createReader((InputStream)fis);
            this.pomObject = reader.readObject();
            reader.close();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
        finally {
            if (fis != null) {
                try {
                    ((InputStream)fis).close();
                }
                catch (IOException iOException) {}
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    public PomJsonReader(InputStream in) {
        try (JsonReader reader = Json.createReader((InputStream)in);){
            this.pomObject = reader.readObject();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
    }

    public JSONDTO readDepsAndRepos(Model model) {
        List<Dependency> deps = this.updateDeps();
        List<RepositoryKey> repos = this.getRepos(model, this.REPOSITORIES_REMOVE, this.REPOSITORIES_UPDATE_URLS, this.REPOSITORIES_ADD);
        List<RepositoryKey> pluginRepos = this.getRepos(model, this.PLUGIN_REPOSITORIES_REMOVE, this.PLUGIN_REPOSITORIES_UPDATE_URLS, this.PLUGIN_REPOSITORIES_ADD);
        return new JSONDTO(deps, repos, pluginRepos);
    }

    private List<RepositoryKey> getRepos(Model model, String remove, String update, String add) {
        Set<RepositoryKey> currentKeys = this.getSetKeys(model.getPluginRepositories());
        Set<RepositoryKey> reposToRemove = this.readReposAsAKeys(remove);
        Set<RepositoryKey> reposToUpdate = this.readReposUpdate(update);
        Set<RepositoryKey> reposToAdd = this.readReposAsAKeys(add);
        if (reposToRemove.size() > 0) {
            currentKeys.removeAll(reposToRemove);
        }
        if (reposToUpdate.size() > 0) {
            this.update(currentKeys, reposToUpdate);
        }
        if (reposToAdd.size() > 0) {
            currentKeys.addAll(reposToAdd);
        }
        return new ArrayList<RepositoryKey>(currentKeys);
    }

    private void update(Set<RepositoryKey> currentRepositories, Set<RepositoryKey> updates) {
        for (RepositoryKey udate : updates) {
            for (RepositoryKey repo : currentRepositories) {
                if (!repo.getRepository().getId().equals(udate.getRepository().getId())) continue;
                repo.getRepository().setUrl(udate.getRepository().getUrl());
            }
        }
    }

    private Set<RepositoryKey> getSetKeys(List<Repository> currentRepositories) {
        HashSet<RepositoryKey> currentKeys = new HashSet<RepositoryKey>();
        for (Repository repo : currentRepositories) {
            currentKeys.add(new RepositoryKey(repo));
        }
        return currentKeys;
    }

    private Set<RepositoryKey> readReposAsAKeys(String repoName) {
        JsonArray repositories = this.pomObject.getJsonArray(repoName);
        HashSet<RepositoryKey> repos = new HashSet<RepositoryKey>(repositories.size());
        for (int i = 0; i < repositories.size(); ++i) {
            Repository repo;
            Repository repository = repo = repoName.endsWith("-add") ? this.getRepository(repositories, i) : this.getRepositoryUpdate(repositories, i);
            if (repo.getId().isEmpty()) continue;
            repos.add(new RepositoryKey(repo));
        }
        return repos;
    }

    private Set<RepositoryKey> readReposUpdate(String repoName) {
        JsonArray repositories = this.pomObject.getJsonArray(repoName);
        HashSet<RepositoryKey> repos = new HashSet<RepositoryKey>(repositories.size());
        for (int i = 0; i < repositories.size(); ++i) {
            Repository repo = this.getRepositoryUpdate(repositories, i);
            if (repo.getId().isEmpty()) continue;
            repos.add(new RepositoryKey(repo));
        }
        return repos;
    }

    private List<Dependency> updateDeps() {
        JsonArray dependencies = this.pomObject.getJsonArray(this.DEPENDENCIES);
        ArrayList<Dependency> deps = new ArrayList<Dependency>(dependencies.size());
        for (int i = 0; i < dependencies.size(); ++i) {
            Dependency dependency = this.getDependency(dependencies, i);
            if (dependency.getGroupId().isEmpty()) continue;
            deps.add(dependency);
        }
        return deps;
    }

    public JSONDTO readDeps() {
        JsonArray dependencies = this.pomObject.getJsonArray(this.DEPENDENCIES);
        ArrayList<Dependency> deps = new ArrayList<Dependency>(dependencies.size());
        for (int i = 0; i < dependencies.size(); ++i) {
            Dependency dependency = this.getDependency(dependencies, i);
            if (dependency.getGroupId().isEmpty()) continue;
            deps.add(dependency);
        }
        return new JSONDTO(deps, Collections.emptyList(), Collections.emptyList());
    }

    private Dependency getDependency(JsonArray dependencies, int i) {
        Dependency dependency = new Dependency();
        String groupId = dependencies.getJsonObject(i).getString("groupId");
        String artifactId = dependencies.getJsonObject(i).getString("artifactId");
        String version = dependencies.getJsonObject(i).getString("version");
        String scope = dependencies.getJsonObject(i).getString("scope");
        if (groupId != null && artifactId != null) {
            dependency.setGroupId(groupId);
            dependency.setArtifactId(artifactId);
            if (version != null) {
                dependency.setVersion(version);
            }
            if (scope != null) {
                dependency.setScope(scope);
            }
        } else {
            return new Dependency();
        }
        return dependency;
    }

    private Repository getRepository(JsonArray pluginRepositories, int i) {
        Repository repo = new Repository();
        repo.setId(pluginRepositories.getJsonObject(i).getString("id"));
        repo.setName(pluginRepositories.getJsonObject(i).getString("name"));
        repo.setUrl(pluginRepositories.getJsonObject(i).getString("url"));
        RepositoryPolicy releases = new RepositoryPolicy();
        releases.setEnabled(pluginRepositories.getJsonObject(i).getBoolean("releasesEnabled"));
        releases.setUpdatePolicy(pluginRepositories.getJsonObject(i).getString("releasesUpdatePolicy"));
        RepositoryPolicy snapshots = new RepositoryPolicy();
        snapshots.setEnabled(pluginRepositories.getJsonObject(i).getBoolean("snapshotEnabled"));
        snapshots.setUpdatePolicy(pluginRepositories.getJsonObject(i).getString("snapshotUpdatePolicy"));
        repo.setSnapshots(snapshots);
        return repo;
    }

    private Repository getRepositoryUpdate(JsonArray pluginRepositories, int i) {
        Repository repo = new Repository();
        repo.setId(pluginRepositories.getJsonObject(i).getString("id"));
        repo.setUrl(pluginRepositories.getJsonObject(i).getString("url"));
        return repo;
    }
}

