/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.service;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.backend.metadata.MetadataServerSideService;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.vfs.Path;

@ApplicationScoped
public class KieServiceOverviewLoader {
    protected static Logger logger = LoggerFactory.getLogger(KieServiceOverviewLoader.class);
    private MetadataServerSideService metadataService;
    private KieModuleService moduleService;
    private WorkspaceProjectService projectService;

    public KieServiceOverviewLoader() {
    }

    @Inject
    public KieServiceOverviewLoader(MetadataServerSideService metadataService, KieModuleService moduleService, WorkspaceProjectService projectService) {
        this.metadataService = metadataService;
        this.moduleService = moduleService;
        this.projectService = projectService;
    }

    public Overview loadOverview(Path path) {
        Overview overview = new Overview();
        try {
            overview.setMetadata(this.metadataService.getMetadata(path));
        }
        catch (Exception e) {
            logger.warn("No metadata found for file: " + path.getFileName() + ", full path [" + path.toString() + "]");
        }
        KieModule module = (KieModule)this.moduleService.resolveModule(path);
        if (module == null) {
            logger.info("File: " + path.getFileName() + ", full path [" + path.toString() + "] was not within a Module. Module Name cannot be set.");
        } else {
            try {
                overview.setProjectName(this.projectService.resolveProject(module.getRootPath()).getName());
            }
            catch (Throwable t) {
                logger.debug("File: " + path.getFileName() + ", full path [" + path.toString() + "] was not within a Project. Project name cannot be set.", t);
            }
        }
        return overview;
    }
}

