/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public abstract class QueueAbstractPacket
extends PacketImpl {
    protected SimpleString queueName;
    protected SimpleString oldVersionQueueName;
    protected SimpleString address;
    protected SimpleString oldVersionAddresseName;

    public SimpleString getQueueName(int clientVersion) {
        if (clientVersion < 129) {
            if (this.oldVersionQueueName == null) {
                this.oldVersionQueueName = this.convertName(this.queueName);
            }
            return this.oldVersionQueueName;
        }
        return this.queueName;
    }

    public SimpleString getAddress(int clientVersion) {
        if (clientVersion < 129) {
            if (this.oldVersionAddresseName == null) {
                this.oldVersionAddresseName = this.convertName(this.address);
            }
            return this.oldVersionAddresseName;
        }
        return this.address;
    }

    public final List<SimpleString> convertQueueNames(int clientVersion, List<SimpleString> queueNames) {
        if (clientVersion < 129) {
            return this.applyAddressPrefixTo(queueNames);
        }
        return queueNames;
    }

    private List<SimpleString> applyAddressPrefixTo(List<SimpleString> queueNames) {
        int names = queueNames.size();
        if (names == 0) {
            return Collections.emptyList();
        }
        SimpleString address = this.address;
        SimpleString prefix = QueueAbstractPacket.jmsPrefixOf(address);
        if (prefix != null) {
            ArrayList<SimpleString> prefixedQueueNames = new ArrayList<SimpleString>(names);
            for (int i = 0; i < names; ++i) {
                SimpleString oldQueueNames = queueNames.get(i);
                SimpleString prefixedQueueName = prefix.concat(oldQueueNames);
                prefixedQueueNames.add(prefixedQueueName);
            }
            return prefixedQueueNames;
        }
        return queueNames;
    }

    private static SimpleString jmsPrefixOf(SimpleString address) {
        if (address.startsWith(OLD_QUEUE_PREFIX)) {
            return OLD_QUEUE_PREFIX;
        }
        if (address.startsWith(OLD_TOPIC_PREFIX)) {
            return OLD_TOPIC_PREFIX;
        }
        return null;
    }

    public QueueAbstractPacket(byte type) {
        super(type);
    }

    public static SimpleString getOldPrefixedAddress(SimpleString address, RoutingType routingType) {
        switch (routingType) {
            case MULTICAST: {
                return OLD_TOPIC_PREFIX.concat(address);
            }
            case ANYCAST: {
                return OLD_QUEUE_PREFIX.concat(address);
            }
        }
        return address;
    }
}

