/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.explorer.utils;

import java.util.Comparator;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.kie.workbench.common.screens.explorer.model.FolderItem;
import org.kie.workbench.common.screens.explorer.model.FolderItemType;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.workbench.type.ClientResourceType;

public class Sorters {
    public static Comparator<OrganizationalUnit> ORGANIZATIONAL_UNIT_SORTER = new Comparator<OrganizationalUnit>(){

        @Override
        public int compare(OrganizationalUnit o1, OrganizationalUnit o2) {
            return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
        }
    };
    public static Comparator<WorkspaceProject> PROJECT_SORTER = new Comparator<WorkspaceProject>(){

        @Override
        public int compare(WorkspaceProject o1, WorkspaceProject o2) {
            return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
        }
    };
    public static Comparator<Module> MODULE_SORTER = new Comparator<Module>(){

        @Override
        public int compare(Module o1, Module o2) {
            return Sorters.toLowerCase(o1.getRootPath()).compareTo(Sorters.toLowerCase(o2.getRootPath()));
        }
    };
    public static Comparator<Package> PACKAGE_SORTER = new Comparator<Package>(){

        @Override
        public int compare(Package o1, Package o2) {
            return o1.getCaption().toLowerCase().compareTo(o2.getCaption().toLowerCase());
        }
    };
    public static Comparator<FolderItem> ITEM_SORTER = new Comparator<FolderItem>(){

        @Override
        public int compare(FolderItem o1, FolderItem o2) {
            if (o1.getItem() instanceof Package && o2.getItem() instanceof Path) {
                return -1;
            }
            if (o1.getItem() instanceof Path && o2.getItem() instanceof Package) {
                return 1;
            }
            if (o1.getItem() instanceof Path) {
                if (!o1.getType().equals((Object)o2.getType())) {
                    if (o1.getType().equals((Object)FolderItemType.FOLDER)) {
                        return -1;
                    }
                    return 1;
                }
                return Sorters.toLowerCase((Path)o1.getItem()).compareTo(Sorters.toLowerCase((Path)o2.getItem()));
            }
            return ((Package)o1.getItem()).getCaption().toLowerCase().compareTo(((Package)o2.getItem()).getCaption().toLowerCase());
        }
    };
    public static Comparator<ClientResourceType> RESOURCE_TYPE_GROUP_SORTER = new Comparator<ClientResourceType>(){

        @Override
        public int compare(ClientResourceType o1, ClientResourceType o2) {
            String o1description = o1.getDescription();
            String o2description = o2.getDescription();
            if (o1description == null && o2description == null) {
                return 0;
            }
            if (o1description == null && o2description != null) {
                return 1;
            }
            if (o1description != null && o2description == null) {
                return -1;
            }
            return o1description.compareTo(o2description);
        }
    };
    public static Comparator<FolderItem> FOLDER_LISTING_SORTER = new Comparator<FolderItem>(){

        @Override
        public int compare(FolderItem o1, FolderItem o2) {
            int comparison = o1.getType().compareTo(o2.getType());
            if (comparison == 0) {
                return this.compareTo(o1, o2);
            }
            return comparison;
        }

        public int compareTo(FolderItem o1, FolderItem o2) {
            if (o1.getItem() instanceof Path) {
                return Sorters.toLowerCase((Path)o1.getItem()).compareTo(Sorters.toLowerCase((Path)o2.getItem()));
            }
            return ((Package)o1.getItem()).getCaption().toLowerCase().compareTo(((Package)o2.getItem()).getCaption().toLowerCase());
        }
    };

    private static String toLowerCase(Path path) {
        return path == null ? "" : path.toURI().toLowerCase();
    }
}

