/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.refactoring.backend.server.query;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.services.refactoring.backend.server.query.standard.FindPackageNamesQuery;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueModuleRootPathIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValuePackageNameIndexTerm;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPageRow;
import org.kie.workbench.common.services.refactoring.service.PackageServiceLoader;
import org.kie.workbench.common.services.refactoring.service.RefactoringQueryService;
import org.uberfire.backend.vfs.Path;

@Service
@ApplicationScoped
public class PackageServiceLoaderImpl
implements PackageServiceLoader {
    @Inject
    private RefactoringQueryService refactoringQueryService;
    @Inject
    private WorkspaceProjectService projectService;

    public Set<String> find(Path path) {
        HashSet<String> result = new HashSet<String>();
        try {
            WorkspaceProject workspaceProject = this.projectService.resolveProject(path);
            List rows = this.refactoringQueryService.query(FindPackageNamesQuery.NAME, this.getValueIndexTerms(workspaceProject));
            for (RefactoringPageRow row : rows) {
                result.add(row.getValue().toString());
            }
        }
        catch (Exception e) {
            return result;
        }
        return result;
    }

    private HashSet<ValueIndexTerm> getValueIndexTerms(WorkspaceProject workspaceProject) {
        HashSet<ValueIndexTerm> queryTerms = new HashSet<ValueIndexTerm>();
        queryTerms.add((ValueIndexTerm)new ValueModuleRootPathIndexTerm(workspaceProject.getMainModule().getRootPath().toURI()));
        queryTerms.add((ValueIndexTerm)new ValuePackageNameIndexTerm("*", ValueIndexTerm.TermSearchType.WILDCARD));
        return queryTerms;
    }
}

