/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.se;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Vetoed;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Singleton;
import org.jboss.weld.bean.builtin.BeanManagerProxy;
import org.jboss.weld.bootstrap.events.AbstractContainerEvent;
import org.jboss.weld.environment.se.WeldContainer;
import org.jboss.weld.environment.se.beans.ParametersFactory;
import org.jboss.weld.environment.se.contexts.ThreadContext;
import org.jboss.weld.environment.se.contexts.activators.ActivateThreadScopeInterceptor;
import org.jboss.weld.environment.se.threading.RunnableDecorator;
import org.jboss.weld.literal.AnyLiteral;
import org.jboss.weld.literal.DefaultLiteral;
import org.jboss.weld.util.annotated.VetoedSuppressedAnnotatedType;
import org.jboss.weld.util.collections.ImmutableSet;

@Vetoed
public class WeldSEBeanRegistrant
implements Extension {
    private ThreadContext threadContext;

    public void registerWeldSEBeans(@Observes BeforeBeanDiscovery event, BeanManager manager) {
        if (WeldSEBeanRegistrant.ignoreEvent(event)) {
            return;
        }
        event.addAnnotatedType((AnnotatedType)VetoedSuppressedAnnotatedType.from(ParametersFactory.class, (BeanManager)manager));
        event.addAnnotatedType((AnnotatedType)VetoedSuppressedAnnotatedType.from(RunnableDecorator.class, (BeanManager)manager));
        event.addAnnotatedType((AnnotatedType)VetoedSuppressedAnnotatedType.from(ActivateThreadScopeInterceptor.class, (BeanManager)manager));
    }

    public void registerWeldSEContexts(@Observes AfterBeanDiscovery event, BeanManager manager) {
        if (WeldSEBeanRegistrant.ignoreEvent(event)) {
            return;
        }
        String contextId = BeanManagerProxy.unwrap((BeanManager)manager).getContextId();
        this.threadContext = new ThreadContext(contextId);
        event.addContext((Context)this.threadContext);
        event.addBean((Bean)new WeldContainerBean(contextId));
    }

    private static boolean ignoreEvent(Object event) {
        return !(event instanceof AbstractContainerEvent);
    }

    public ThreadContext getThreadContext() {
        return this.threadContext;
    }

    private static class WeldContainerBean
    implements Bean<WeldContainer> {
        private final String contextId;

        private WeldContainerBean(String contextId) {
            this.contextId = contextId;
        }

        public WeldContainer create(CreationalContext<WeldContainer> creationalContext) {
            return WeldContainer.instance(this.contextId);
        }

        public void destroy(WeldContainer instance, CreationalContext<WeldContainer> creationalContext) {
        }

        public Set<Type> getTypes() {
            return ImmutableSet.of((Object[])new Type[]{WeldContainer.class, Object.class});
        }

        public Set<Annotation> getQualifiers() {
            return ImmutableSet.of((Object[])new Annotation[]{AnyLiteral.INSTANCE, DefaultLiteral.INSTANCE});
        }

        public Class<? extends Annotation> getScope() {
            return Singleton.class;
        }

        public String getName() {
            return null;
        }

        public Set<Class<? extends Annotation>> getStereotypes() {
            return Collections.emptySet();
        }

        public boolean isAlternative() {
            return false;
        }

        public Class<?> getBeanClass() {
            return WeldSEBeanRegistrant.class;
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return Collections.emptySet();
        }

        public boolean isNullable() {
            return false;
        }
    }
}

