/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.simulation.impl.time;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.math3.random.RandomDataGenerator;
import org.jbpm.simulation.TimeGenerator;
import org.jbpm.simulation.util.SimulationUtils;

public class NormalTimeGenerator
implements TimeGenerator {
    private Map<String, Object> data;
    private static RandomDataGenerator generator = new RandomDataGenerator();
    private TimeUnit timeUnit = TimeUnit.MILLISECONDS;

    public NormalTimeGenerator(Map<String, Object> data) {
        this.data = data;
    }

    @Override
    public long generateTime() {
        TimeUnit tu = SimulationUtils.getTimeUnit(this.data);
        long mean = (long)SimulationUtils.asDouble(this.data.get("mean"));
        mean = this.timeUnit.convert(mean, tu);
        long sdv = (long)SimulationUtils.asDouble(this.data.get("standarddeviation"));
        if ((sdv = this.timeUnit.convert(sdv, tu)) > 0L) {
            long value = (long)generator.nextGaussian((double)mean, (double)sdv);
            if (value <= 0L) {
                value = mean;
            }
            return value;
        }
        return 0L;
    }
}

