/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.compiler.xml.processes;

import java.util.HashSet;
import org.drools.core.xml.BaseAbstractHandler;
import org.drools.core.xml.ExtensibleXmlParser;
import org.drools.core.xml.Handler;
import org.jbpm.compiler.xml.processes.ActionNodeHandler;
import org.jbpm.process.core.Context;
import org.jbpm.process.core.ContextContainer;
import org.jbpm.process.core.context.exception.ActionExceptionHandler;
import org.jbpm.process.core.context.exception.ExceptionHandler;
import org.jbpm.process.core.context.exception.ExceptionScope;
import org.jbpm.workflow.core.DroolsAction;
import org.kie.api.definition.process.Process;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ExceptionHandlerHandler
extends BaseAbstractHandler
implements Handler {
    public ExceptionHandlerHandler() {
        if (this.validParents == null && this.validPeers == null) {
            this.validParents = new HashSet();
            this.validParents.add(Process.class);
            this.validPeers = new HashSet();
            this.validPeers.add(null);
            this.allowNesting = false;
        }
    }

    public Object start(String uri, String localName, Attributes attrs, ExtensibleXmlParser parser) throws SAXException {
        parser.startElementBuilder(localName, attrs);
        return null;
    }

    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        ExceptionScope exceptionScope;
        Element element = parser.endElementBuilder();
        ContextContainer contextContainer = (ContextContainer)parser.getParent();
        String type = element.getAttribute("type");
        this.emptyAttributeCheck(localName, "type", type, parser);
        String faultName = element.getAttribute("faultName");
        this.emptyAttributeCheck(localName, "faultName", type, parser);
        String faultVariable = element.getAttribute("faultVariable");
        ActionExceptionHandler exceptionHandler = null;
        if ("action".equals(type)) {
            exceptionHandler = new ActionExceptionHandler();
            Node xmlNode = element.getFirstChild();
            if (xmlNode instanceof Element) {
                Element actionXml = (Element)xmlNode;
                DroolsAction action = ActionNodeHandler.extractAction(actionXml);
                exceptionHandler.setAction(action);
            }
        } else {
            throw new SAXParseException("Unknown exception handler type " + type, parser.getLocator());
        }
        if (faultVariable != null && faultVariable.length() > 0) {
            exceptionHandler.setFaultVariable(faultVariable);
        }
        if ((exceptionScope = (ExceptionScope)contextContainer.getDefaultContext("ExceptionScope")) == null) {
            exceptionScope = new ExceptionScope();
            contextContainer.addContext((Context)exceptionScope);
            contextContainer.setDefaultContext((Context)exceptionScope);
        }
        exceptionScope.setExceptionHandler(faultName, (ExceptionHandler)exceptionHandler);
        return null;
    }

    public Class<?> generateNodeFor() {
        return null;
    }
}

