/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.client;

import java.util.Arrays;
import java.util.HashSet;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.taskassigning.LocalDateTimeValue;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesFactory;
import org.kie.server.client.TaskAssigningRuntimeClient;

public class TaskAssigningRuntimeClientFactory {
    private TaskAssigningRuntimeClientFactory() {
    }

    static KieServicesClient createKieServicesClient(String endpoint, String login, String password, long timeout) {
        KieServicesConfiguration configuration = KieServicesFactory.newRestConfiguration(endpoint, login, password);
        configuration.setTimeout(timeout);
        configuration.setCapabilities(Arrays.asList("BPM", "TaskAssigningRuntime"));
        configuration.setMarshallingFormat(MarshallingFormat.XSTREAM);
        HashSet extraClasses = new HashSet();
        extraClasses.add(LocalDateTimeValue.class);
        configuration.setExtraClasses(extraClasses);
        return KieServicesFactory.newKieServicesClient(configuration);
    }

    public static TaskAssigningRuntimeClient newRuntimeClient(String endpoint, String login, String password, long timeout) {
        KieServicesClient servicesClient = TaskAssigningRuntimeClientFactory.createKieServicesClient(endpoint, login, password, timeout);
        return servicesClient.getServicesClient(TaskAssigningRuntimeClient.class);
    }

    static {
        System.setProperty("org.kie.server.bypass.auth.user", Boolean.TRUE.toString());
    }
}

