/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.tree.compiler.factories;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.False;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.True;
import org.dmg.pmml.tree.LeafNode;
import org.dmg.pmml.tree.Node;
import org.dmg.pmml.tree.TreeModel;
import org.kie.pmml.api.enums.DATA_TYPE;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsRule;
import org.kie.pmml.models.drools.ast.factories.KiePMMLPredicateASTFactory;
import org.kie.pmml.models.drools.ast.factories.PredicateASTFactoryData;
import org.kie.pmml.models.drools.commons.utils.KiePMMLDroolsModelUtils;
import org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLTreeModelNodeASTFactory {
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLTreeModelNodeASTFactory.class.getName());
    private final Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap;
    private final List<KiePMMLOutputField> outputFields;
    private final TreeModel.NoTrueChildStrategy noTrueChildStrategy;
    private final DATA_TYPE targetType;

    private KiePMMLTreeModelNodeASTFactory(Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap, List<KiePMMLOutputField> outputFields, TreeModel.NoTrueChildStrategy noTrueChildStrategy, DATA_TYPE targetType) {
        this.fieldTypeMap = fieldTypeMap;
        this.outputFields = outputFields;
        this.noTrueChildStrategy = noTrueChildStrategy;
        this.targetType = targetType;
    }

    public static KiePMMLTreeModelNodeASTFactory factory(Map<String, KiePMMLOriginalTypeGeneratedType> fieldTypeMap, List<KiePMMLOutputField> outputFields, TreeModel.NoTrueChildStrategy noTrueChildStrategy, DATA_TYPE targetType) {
        return new KiePMMLTreeModelNodeASTFactory(fieldTypeMap, outputFields, noTrueChildStrategy, targetType);
    }

    public List<KiePMMLDroolsRule> declareRulesFromRootNode(Node node, String parentPath) {
        logger.trace("declareRulesFromRootNode {} {}", (Object)node, (Object)parentPath);
        ArrayList<KiePMMLDroolsRule> toReturn = new ArrayList<KiePMMLDroolsRule>();
        this.declareRuleFromNode(node, parentPath, toReturn);
        return toReturn;
    }

    protected void declareRuleFromNode(Node node, String parentPath, List<KiePMMLDroolsRule> rules) {
        logger.trace("declareRuleFromNode {} {}", (Object)node, (Object)parentPath);
        if (this.isFinalLeaf(node)) {
            this.declareFinalRuleFromNode(node, parentPath, rules);
        } else {
            this.declareIntermediateRuleFromNode(node, parentPath, rules);
            if (TreeModel.NoTrueChildStrategy.RETURN_LAST_PREDICTION.equals((Object)this.noTrueChildStrategy) && node.getScore() != null) {
                this.declareDefaultRuleFromNode(node, parentPath, rules);
            }
        }
    }

    protected void declareFinalRuleFromNode(Node node, String parentPath, List<KiePMMLDroolsRule> rules) {
        logger.trace("declareFinalRuleFromNode {} {}", (Object)node, (Object)parentPath);
        Predicate predicate = node.getPredicate();
        if (predicate instanceof False) {
            return;
        }
        String currentRule = String.format("%s_%s", parentPath, node.getScore());
        PredicateASTFactoryData predicateASTFactoryData = new PredicateASTFactoryData(predicate, this.outputFields, rules, parentPath, currentRule, this.fieldTypeMap);
        KiePMMLPredicateASTFactory.factory((PredicateASTFactoryData)predicateASTFactoryData).declareRuleFromPredicate(KiePMMLDroolsModelUtils.getCorrectlyFormattedResult((Object)node.getScore(), (DATA_TYPE)this.targetType), true);
    }

    protected void declareIntermediateRuleFromNode(Node node, String parentPath, List<KiePMMLDroolsRule> rules) {
        logger.trace("declareIntermediateRuleFromNode {} {}", (Object)node, (Object)parentPath);
        Predicate predicate = node.getPredicate();
        if (predicate instanceof False) {
            return;
        }
        String currentRule = String.format("%s_%s", parentPath, node.getScore());
        PredicateASTFactoryData predicateASTFactoryData = new PredicateASTFactoryData(predicate, this.outputFields, rules, parentPath, currentRule, this.fieldTypeMap);
        KiePMMLPredicateASTFactory.factory((PredicateASTFactoryData)predicateASTFactoryData).declareRuleFromPredicate(KiePMMLDroolsModelUtils.getCorrectlyFormattedResult((Object)node.getScore(), (DATA_TYPE)this.targetType), false);
        node.getNodes().forEach(child -> this.declareRuleFromNode((Node)child, currentRule, rules));
    }

    protected void declareDefaultRuleFromNode(Node node, String parentPath, List<KiePMMLDroolsRule> rules) {
        logger.trace("declareDefaultRuleFromNode {} {}", (Object)node, (Object)parentPath);
        String originalRule = String.format("%s_%s", parentPath, node.getScore());
        String currentRule = String.format("%s_%s", "default", originalRule);
        PredicateASTFactoryData predicateASTFactoryData = new PredicateASTFactoryData((Predicate)new True(), this.outputFields, rules, originalRule, currentRule, this.fieldTypeMap);
        KiePMMLPredicateASTFactory.factory((PredicateASTFactoryData)predicateASTFactoryData).declareRuleFromPredicate(KiePMMLDroolsModelUtils.getCorrectlyFormattedResult((Object)node.getScore(), (DATA_TYPE)this.targetType), true);
    }

    protected boolean isFinalLeaf(Node node) {
        return node instanceof LeafNode || node.getNodes() == null || node.getNodes().isEmpty();
    }
}

