/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dmg.pmml.Array;
import org.dmg.pmml.ComplexValue;

public class ArrayUtil {
    private ArrayUtil() {
    }

    public static List<String> parse(Array.Type type, String string) {
        boolean enableQuotes;
        ArrayList<String> result = new ArrayList<String>(Math.max(16, string.length() / 8));
        StringBuilder sb = new StringBuilder();
        switch (type) {
            case INT: 
            case REAL: {
                enableQuotes = false;
                break;
            }
            case STRING: {
                enableQuotes = true;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        boolean quoted = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (quoted) {
                if (c == '\\' && i < string.length() - 1) {
                    c = string.charAt(i + 1);
                    if (c == '\"') {
                        sb.append('\"');
                        ++i;
                        continue;
                    }
                    sb.append('\\');
                    continue;
                }
                sb.append(c);
                if (c != '\"') continue;
                result.add(ArrayUtil.createToken(sb, enableQuotes));
                quoted = false;
                continue;
            }
            if (c == '\"' && enableQuotes) {
                if (sb.length() > 0) {
                    result.add(ArrayUtil.createToken(sb, enableQuotes));
                }
                sb.append('\"');
                quoted = true;
                continue;
            }
            if (Character.isWhitespace(c)) {
                if (sb.length() <= 0) continue;
                result.add(ArrayUtil.createToken(sb, enableQuotes));
                continue;
            }
            sb.append(c);
        }
        if (sb.length() > 0) {
            result.add(ArrayUtil.createToken(sb, enableQuotes));
        }
        return result;
    }

    public static String format(Array.Type type, Collection<?> values) {
        boolean enableQuotes;
        StringBuilder sb = new StringBuilder(values.size() * 16);
        switch (type) {
            case INT: 
            case REAL: {
                enableQuotes = false;
                break;
            }
            case STRING: {
                enableQuotes = true;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        for (Object value : values) {
            if (value instanceof ComplexValue) {
                ComplexValue complexValue = (ComplexValue)value;
                value = complexValue.toSimpleValue();
            }
            String string = value.toString();
            if (sb.length() > 0) {
                sb.append(' ');
            }
            if (enableQuotes) {
                boolean quoted;
                boolean bl = quoted = "".equals(string) || string.indexOf(32) > -1;
                if (quoted) {
                    sb.append('\"');
                }
                if (string.indexOf(34) > -1) {
                    for (int i = 0; i < string.length(); ++i) {
                        char c = string.charAt(i);
                        if (c == '\"') {
                            sb.append('\\');
                        }
                        sb.append(c);
                    }
                } else {
                    sb.append(string);
                }
                if (!quoted) continue;
                sb.append('\"');
                continue;
            }
            sb.append(string);
        }
        return sb.toString();
    }

    private static String createToken(StringBuilder sb, boolean enableQuotes) {
        String result = sb.length() > 1 && sb.charAt(0) == '\"' && sb.charAt(sb.length() - 1) == '\"' && enableQuotes ? sb.substring(1, sb.length() - 1) : sb.substring(0, sb.length());
        sb.setLength(0);
        return result;
    }
}

