/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.commons.utils;

import java.util.function.Predicate;
import org.kie.pmml.api.exceptions.KiePMMLException;

public class ConverterTypeUtil {
    static final String FAILED_CONVERSION = "Failed to convert %s to %s";
    private static Predicate<Class<?>> IS_BOOLEAN = expectedClass -> expectedClass.isAssignableFrom(Boolean.class) || expectedClass.isAssignableFrom(Boolean.TYPE);
    private static Predicate<Class<?>> IS_INTEGER = expectedClass -> expectedClass.isAssignableFrom(Integer.class) || expectedClass.isAssignableFrom(Integer.TYPE);
    private static Predicate<Class<?>> IS_LONG = expectedClass -> expectedClass.isAssignableFrom(Long.class) || expectedClass.isAssignableFrom(Long.TYPE);
    private static Predicate<Class<?>> IS_DOUBLE = expectedClass -> expectedClass.isAssignableFrom(Double.class) || expectedClass.isAssignableFrom(Double.TYPE);
    private static Predicate<Class<?>> IS_FLOAT = expectedClass -> expectedClass.isAssignableFrom(Float.class) || expectedClass.isAssignableFrom(Float.TYPE);
    private static Predicate<Class<?>> IS_CHARACTER = expectedClass -> expectedClass.isAssignableFrom(Character.class) || expectedClass.isAssignableFrom(Character.TYPE);
    private static Predicate<Class<?>> IS_BYTE = expectedClass -> expectedClass.isAssignableFrom(Byte.class) || expectedClass.isAssignableFrom(Byte.TYPE);
    private static Predicate<Class<?>> IS_SHORT = expectedClass -> expectedClass.isAssignableFrom(Short.class) || expectedClass.isAssignableFrom(Short.TYPE);

    private ConverterTypeUtil() {
    }

    public static Object convert(Class<?> expectedClass, Object originalObject) {
        Object toReturn;
        if (originalObject == null) {
            return null;
        }
        Class<?> currentClass = originalObject.getClass();
        if (expectedClass.isAssignableFrom(currentClass)) {
            return originalObject;
        }
        if (currentClass.equals(String.class)) {
            try {
                toReturn = ConverterTypeUtil.convertFromString(expectedClass, (String)originalObject);
            }
            catch (Exception e) {
                throw new KiePMMLException(String.format(FAILED_CONVERSION, originalObject, expectedClass.getName()), (Throwable)e);
            }
        } else if (expectedClass == String.class) {
            toReturn = originalObject.toString();
        } else {
            throw new KiePMMLException(String.format(FAILED_CONVERSION, originalObject, expectedClass.getName()));
        }
        return toReturn;
    }

    static Object convertFromString(Class<?> expectedClass, String originalObject) {
        if (IS_BOOLEAN.test(expectedClass)) {
            return ConverterTypeUtil.parseBoolean(originalObject);
        }
        if (IS_INTEGER.test(expectedClass)) {
            return Integer.parseInt(originalObject);
        }
        if (IS_LONG.test(expectedClass)) {
            return Long.parseLong(originalObject);
        }
        if (IS_DOUBLE.test(expectedClass)) {
            return Double.parseDouble(originalObject);
        }
        if (IS_FLOAT.test(expectedClass)) {
            return Float.valueOf(Float.parseFloat(originalObject));
        }
        if (IS_CHARACTER.test(expectedClass)) {
            return Character.valueOf(ConverterTypeUtil.parseChar(originalObject));
        }
        if (IS_BYTE.test(expectedClass)) {
            return Byte.parseByte(originalObject);
        }
        if (IS_SHORT.test(expectedClass)) {
            return Short.parseShort(originalObject);
        }
        throw new KiePMMLException(String.format(FAILED_CONVERSION, originalObject, expectedClass.getName()));
    }

    private static boolean parseBoolean(String value) {
        if ("true".equalsIgnoreCase(value)) {
            return true;
        }
        if ("false".equalsIgnoreCase(value)) {
            return false;
        }
        throw new IllegalArgumentException("Impossible to parse as boolean " + value);
    }

    private static char parseChar(String value) {
        if (value == null || value.length() != 1) {
            throw new IllegalArgumentException("Impossible to transform " + value + " as char");
        }
        return value.charAt(0);
    }
}

