/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.websocket.notification;

import javax.annotation.PostConstruct;
import javax.websocket.CloseReason;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.kie.server.controller.websocket.common.encoder.KieServerControllerNotificationEncoder;
import org.kie.server.controller.websocket.notification.WebSocketNotificationSessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServerEndpoint(value="/websocket/controller/notification", encoders={KieServerControllerNotificationEncoder.class})
public class WebSocketKieServerControllerNotification {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketKieServerControllerNotification.class);
    private WebSocketNotificationSessionManager manager = WebSocketNotificationSessionManager.getInstance();

    @PostConstruct
    public void configure() {
        LOGGER.info("Kie Server Controller WebSocket Notification service initialized");
    }

    @OnOpen
    public void onNotificationClientConnect(Session session) {
        LOGGER.debug("New Web Socket Notification Client session: {}", (Object)session.getId());
        this.manager.addSession(session);
    }

    @OnClose
    public void onNotificationClientDisconnect(Session session, CloseReason closeReason) {
        LOGGER.debug("Web Socket Notification Client session: {}, disconnected, reason: {}", (Object)session.getId(), (Object)closeReason);
        this.manager.removeSession(session);
    }

    @OnError
    public void onNotificationClientError(Session session, Throwable e) {
        LOGGER.error("Web Socket Notification Client session: {}, unexpected error", (Object)session.getId(), (Object)e);
    }
}

