/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.impl.service;

import java.util.List;
import org.kie.server.controller.api.model.events.ServerInstanceConnected;
import org.kie.server.controller.api.model.events.ServerInstanceDeleted;
import org.kie.server.controller.api.model.events.ServerInstanceDisconnected;
import org.kie.server.controller.api.model.events.ServerInstanceUpdated;
import org.kie.server.controller.api.model.events.ServerTemplateDeleted;
import org.kie.server.controller.api.model.events.ServerTemplateUpdated;
import org.kie.server.controller.api.model.runtime.Container;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.service.NotificationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingNotificationService
implements NotificationService {
    private static final Logger logger = LoggerFactory.getLogger(LoggingNotificationService.class);
    private static LoggingNotificationService INSTANCE = new LoggingNotificationService();

    protected LoggingNotificationService() {
    }

    public static LoggingNotificationService getInstance() {
        return INSTANCE;
    }

    public void notify(ServerTemplate serverTemplate, ContainerSpec containerSpec, List<Container> containers) {
        logger.info("Notification about change requested on server {} with container spec {} with following result {}", new Object[]{serverTemplate, containerSpec, containers});
    }

    public void notify(ServerTemplateUpdated serverTemplateUpdated) {
        logger.info("Notify on update :: {}", (Object)serverTemplateUpdated);
    }

    public void notify(ServerTemplateDeleted serverTemplateDeleted) {
        logger.info("Notify on delete :: {}", (Object)serverTemplateDeleted);
    }

    public void notify(ServerInstanceUpdated serverInstanceUpdated) {
        logger.info("Notify on instance update :: {}", (Object)serverInstanceUpdated);
    }

    public void notify(ServerInstanceDeleted serverInstanceDeleted) {
        logger.info("Notify on instance delete :: {}", (Object)serverInstanceDeleted);
    }

    public void notify(ServerInstanceConnected serverInstanceConnected) {
        logger.info("Notify on instance connected :: {}", (Object)serverInstanceConnected);
    }

    public void notify(ServerInstanceDisconnected serverInstanceDisconnected) {
        logger.info("Notify on instance disconnect :: {}", (Object)serverInstanceDisconnected);
    }
}

