/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util.commands;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.patch.FileHeader;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.java.nio.base.TextualDiff;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.commands.BranchUtil;
import org.uberfire.java.nio.fs.jgit.util.commands.CustomDiffCommand;
import org.uberfire.java.nio.fs.jgit.util.exceptions.GitException;

public class TextualDiffBranches {
    private final Git git;
    private final String branchA;
    private final String branchB;
    private final String commitIdBranchA;
    private final String commitIdBranchB;
    private static final String DIFF_REGEX_DELIMITER = "diff --git.*";
    private static final String DIFF_KEY = "diff --git a/%s b/%s";

    public TextualDiffBranches(Git git, String branchA, String branchB) {
        this(git, branchA, branchB, null, null);
    }

    public TextualDiffBranches(Git git, String branchA, String branchB, String commitIdBranchA, String commitIdBranchB) {
        this.git = (Git)PortablePreconditions.checkNotNull((String)"git", (Object)git);
        this.branchA = PortablePreconditions.checkNotEmpty((String)"branchA", (String)branchA);
        this.branchB = PortablePreconditions.checkNotEmpty((String)"branchB", (String)branchB);
        this.commitIdBranchA = commitIdBranchA;
        this.commitIdBranchB = commitIdBranchB;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<TextualDiff> execute() {
        DiffFormatter formatter = this.createFormatter();
        BranchUtil.existsBranch(this.git, this.branchA);
        BranchUtil.existsBranch(this.git, this.branchB);
        try (ObjectReader reader = this.git.getRepository().newObjectReader();){
            RevCommit commitA = this.commitIdBranchA != null ? this.git.getCommit(this.commitIdBranchA) : this.git.getCommonAncestorCommit(this.branchA, this.branchB);
            RevCommit commitB = this.commitIdBranchB != null ? this.git.getCommit(this.commitIdBranchB) : this.git.getLastCommit(this.branchB);
            CanonicalTreeParser oldTreeIter = new CanonicalTreeParser();
            oldTreeIter.reset(reader, (AnyObjectId)commitA.getTree());
            CanonicalTreeParser newTreeIter = new CanonicalTreeParser();
            newTreeIter.reset(reader, (AnyObjectId)commitB.getTree());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Object diffEntries = new CustomDiffCommand(this.git).setNewTree((AbstractTreeIterator)newTreeIter).setOldTree((AbstractTreeIterator)oldTreeIter).setOutputStream(out).call();
            List<String> parts = TextualDiffBranches.splitWithDelimiters(String.valueOf(out), DIFF_REGEX_DELIMITER);
            HashMap<String, String> diffMap = new HashMap<String, String>();
            int j = 0;
            for (int i = 1; i < parts.size(); i += 2, ++j) {
                String diffKey = this.buildDiffKey(((DiffEntry)diffEntries.get(j)).getChangeType(), ((DiffEntry)diffEntries.get(j)).getOldPath(), ((DiffEntry)diffEntries.get(j)).getNewPath());
                diffMap.put(diffKey, parts.get(i));
            }
            List<TextualDiff> list = diffEntries.stream().map(entry -> this.getFileHeader(formatter, (DiffEntry)entry)).map(header -> {
                int linesAdded = header.toEditList().stream().mapToInt(elem -> elem.getEndB() - elem.getBeginB()).sum();
                int linesDeleted = header.toEditList().stream().mapToInt(elem -> elem.getEndA() - elem.getBeginA()).sum();
                DiffEntry.ChangeType changeType = header.getChangeType();
                String diffKey = this.buildDiffKey(changeType, header.getOldPath(), header.getNewPath());
                String diffText = diffKey + (String)diffMap.get(diffKey);
                return new TextualDiff(header.getOldPath(), header.getNewPath(), changeType.toString(), linesAdded, linesDeleted, diffText);
            }).collect(Collectors.toList());
            return list;
        }
        catch (Exception e) {
            throw new GitException("Unable to get textual diff", e);
        }
    }

    private String buildDiffKey(DiffEntry.ChangeType changeType, String oldPath, String newPath) {
        return String.format(DIFF_KEY, changeType != DiffEntry.ChangeType.ADD ? oldPath : newPath, changeType != DiffEntry.ChangeType.DELETE ? newPath : oldPath);
    }

    private DiffFormatter createFormatter() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        DiffFormatter formatter = new DiffFormatter((OutputStream)outputStream);
        formatter.setRepository(this.git.getRepository());
        return formatter;
    }

    private FileHeader getFileHeader(DiffFormatter formatter, DiffEntry elem) {
        try {
            return formatter.toFileHeader(elem);
        }
        catch (IOException e) {
            throw new GitException("A problem occurred when trying to obtain diffs between files", e);
        }
    }

    private static List<String> splitWithDelimiters(String str, String regex) {
        ArrayList<String> parts = new ArrayList<String>();
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(str);
        int lastEnd = 0;
        while (m.find()) {
            int start = m.start();
            if (lastEnd != start) {
                String nonDelim = str.substring(lastEnd, start);
                parts.add(nonDelim);
            }
            String delim = m.group();
            parts.add(delim);
            lastEnd = m.end();
        }
        if (lastEnd != str.length()) {
            String nonDelim = str.substring(lastEnd);
            parts.add(nonDelim);
        }
        return parts;
    }
}

